/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.ast.model;

import com.github.javaparser.Position;
import com.github.javaparser.ast.Node;
import com.github.javaparser.utils.Pair;
import de.tum.in.test.api.localization.Messages;
import java.util.Comparator;
import java.util.Optional;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class NodePosition
implements Comparable<NodePosition> {
    private static final Comparator<NodePosition> COMPARATOR = Comparator.comparing(NodePosition::getBeginLine).thenComparing(NodePosition::getBeginColumn);
    private final boolean hasBegin;
    private final Pair<Integer, Integer> begin;
    private final boolean hasEnd;
    private final Pair<Integer, Integer> end;

    public NodePosition(Node node) {
        Optional nodeBegin = node.getBegin();
        this.hasBegin = nodeBegin.isPresent();
        this.begin = this.hasBegin ? new Pair((Object)((Position)nodeBegin.get()).line, (Object)((Position)nodeBegin.get()).column) : null;
        Optional nodeEnd = node.getEnd();
        this.hasEnd = nodeEnd.isPresent();
        this.end = this.hasEnd ? new Pair((Object)((Position)nodeEnd.get()).line, (Object)((Position)nodeEnd.get()).column) : null;
    }

    public int getBeginLine() {
        return (Integer)this.begin.a;
    }

    public int getBeginColumn() {
        return (Integer)this.begin.b;
    }

    public String toString() {
        return Messages.localized("ast.method.to_string", this.hasBegin ? Messages.localized("ast.check.has_begin_end", this.begin.a, this.begin.b) : Messages.localized("ast.check.not_has_begin", new Object[0]), this.hasEnd ? Messages.localized("ast.check.has_begin_end", this.end.a, this.end.b) : Messages.localized("ast.check.not_has_end", new Object[0]));
    }

    public static NodePosition getPositionOf(Node node) {
        return new NodePosition(node);
    }

    @Override
    public int compareTo(NodePosition o) {
        return COMPARATOR.compare(this, o);
    }
}

