/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.structural;

import de.tum.in.test.api.localization.Messages;
import de.tum.in.test.api.structural.StructuralTestProvider;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apiguardian.api.API;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicTest;

@API(status=API.Status.STABLE)
public abstract class MethodTestProvider
extends StructuralTestProvider {
    protected DynamicContainer generateTestsForAllClasses() throws URISyntaxException {
        ArrayList<DynamicTest> tests = new ArrayList<DynamicTest>();
        if (structureOracleJSON == null) {
            throw MethodTestProvider.failure("The MethodTest test can only run if the structural oracle (test.json) is present. If you do not provide it, delete MethodTest.java!");
        }
        for (int i = 0; i < structureOracleJSON.length(); ++i) {
            JSONObject expectedClassJSON = structureOracleJSON.getJSONObject(i);
            if (!expectedClassJSON.has("class") || !expectedClassJSON.has("methods")) continue;
            JSONObject expectedClassPropertiesJSON = expectedClassJSON.getJSONObject("class");
            String expectedClassName = expectedClassPropertiesJSON.getString("name");
            String expectedPackageName = expectedClassPropertiesJSON.getString("package");
            StructuralTestProvider.ExpectedClassStructure expectedClassStructure = new StructuralTestProvider.ExpectedClassStructure(expectedClassName, expectedPackageName, expectedClassJSON);
            tests.add(DynamicTest.dynamicTest((String)("testMethods[" + expectedClassName + "]"), () -> MethodTestProvider.testMethods(expectedClassStructure)));
        }
        if (tests.isEmpty()) {
            throw MethodTestProvider.failure("No tests for methods available in the structural oracle (test.json). Either provide attributes information or delete MethodTest.java!");
        }
        return DynamicContainer.dynamicContainer((String)this.getClass().getName(), (URI)new URI(this.getClass().getName()), tests.stream());
    }

    public static void testMethods(StructuralTestProvider.ExpectedClassStructure expectedClassStructure) {
        String expectedClassName = expectedClassStructure.getExpectedClassName();
        Class<?> observedClass = MethodTestProvider.findClassForTestType(expectedClassStructure, "method");
        if (expectedClassStructure.hasProperty("methods")) {
            JSONArray methodsJSON = expectedClassStructure.getPropertyAsJsonArray("methods");
            MethodTestProvider.checkMethods(expectedClassName, observedClass, methodsJSON);
        }
    }

    protected static void checkMethods(String expectedClassName, Class<?> observedClass, JSONArray expectedMethods) {
        for (int i = 0; i < expectedMethods.length(); ++i) {
            JSONObject expectedMethod = expectedMethods.getJSONObject(i);
            String expectedName = expectedMethod.getString("name");
            JSONArray expectedParameters = MethodTestProvider.getExpectedJsonProperty(expectedMethod, "parameters");
            JSONArray expectedModifiers = MethodTestProvider.getExpectedJsonProperty(expectedMethod, "modifiers");
            JSONArray expectedAnnotations = MethodTestProvider.getExpectedJsonProperty(expectedMethod, "annotations");
            String expectedReturnType = expectedMethod.getString("returnType");
            boolean strictParameterOrder = MethodTestProvider.getExpectedJsonBooleanProperty(expectedMethod, "strictOrder");
            MethodChecks checks = new MethodChecks();
            for (Method observedMethod : observedClass.getDeclaredMethods()) {
                if (!expectedName.equals(observedMethod.getName())) continue;
                checks.name = true;
                checks.parameters = MethodTestProvider.checkParameters(observedMethod.getParameterTypes(), expectedParameters, strictParameterOrder);
                checks.modifiers = MethodTestProvider.checkModifiers(Modifier.toString(observedMethod.getModifiers()).split(" "), expectedModifiers);
                checks.annotations = MethodTestProvider.checkAnnotations(observedMethod.getAnnotations(), expectedAnnotations);
                checks.returnType = MethodTestProvider.checkExpectedType(observedMethod.getReturnType(), observedMethod.getGenericReturnType(), expectedReturnType);
                if (checks.hasPassedAll()) break;
            }
            MethodTestProvider.checkMethodCorrectness(expectedClassName, expectedName, expectedParameters, checks);
        }
    }

    private static void checkMethodCorrectness(String expectedClassName, String expectedName, JSONArray expectedParameters, MethodChecks methodChecks) {
        String parameters = StructuralTestProvider.describeParameters(expectedParameters);
        if (!methodChecks.name) {
            throw Messages.localizedFailure("structural.method.name", expectedName, expectedClassName, parameters);
        }
        if (!methodChecks.parameters) {
            throw Messages.localizedFailure("structural.method.parameters", expectedName, expectedClassName, parameters);
        }
        if (!methodChecks.modifiers) {
            throw Messages.localizedFailure("structural.method.modifiers", expectedName, expectedClassName, parameters);
        }
        if (!methodChecks.annotations) {
            throw Messages.localizedFailure("structural.method.annoations", expectedName, expectedClassName, parameters);
        }
        if (!methodChecks.returnType) {
            throw Messages.localizedFailure("structural.method.return", expectedName, expectedClassName, parameters);
        }
    }

    private static class MethodChecks {
        boolean name;
        boolean parameters;
        boolean modifiers;
        boolean annotations;
        boolean returnType;

        private MethodChecks() {
        }

        boolean hasPassedAll() {
            return this.name && this.parameters && this.modifiers && this.annotations && this.returnType;
        }
    }
}

