/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.structural;

import de.tum.in.test.api.localization.Messages;
import de.tum.in.test.api.structural.StructuralTestProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apiguardian.api.API;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicTest;

@API(status=API.Status.STABLE)
public abstract class ConstructorTestProvider
extends StructuralTestProvider {
    protected DynamicContainer generateTestsForAllClasses() throws URISyntaxException {
        ArrayList<DynamicTest> tests = new ArrayList<DynamicTest>();
        if (structureOracleJSON == null) {
            throw ConstructorTestProvider.failure("The ConstructorTest can only run if the structural oracle (test.json) is present. If you do not provide it, delete ConstructorTest.java!");
        }
        for (int i = 0; i < structureOracleJSON.length(); ++i) {
            JSONObject expectedClassJSON = structureOracleJSON.getJSONObject(i);
            if (!expectedClassJSON.has("class") || !expectedClassJSON.has("constructors")) continue;
            JSONObject expectedClassPropertiesJSON = expectedClassJSON.getJSONObject("class");
            String expectedClassName = expectedClassPropertiesJSON.getString("name");
            String expectedPackageName = expectedClassPropertiesJSON.getString("package");
            StructuralTestProvider.ExpectedClassStructure expectedClassStructure = new StructuralTestProvider.ExpectedClassStructure(expectedClassName, expectedPackageName, expectedClassJSON);
            tests.add(DynamicTest.dynamicTest((String)("testConstructors[" + expectedClassName + "]"), () -> ConstructorTestProvider.testConstructors(expectedClassStructure)));
        }
        if (tests.isEmpty()) {
            throw ConstructorTestProvider.failure("No tests for constructors available in the structural oracle (test.json). Either provide constructor information or delete ConstructorTest.java!");
        }
        return DynamicContainer.dynamicContainer((String)this.getClass().getName(), (URI)new URI(this.getClass().getName()), tests.stream());
    }

    protected static void testConstructors(StructuralTestProvider.ExpectedClassStructure expectedClassStructure) {
        String expectedClassName = expectedClassStructure.getExpectedClassName();
        Class<?> observedClass = ConstructorTestProvider.findClassForTestType(expectedClassStructure, "constructor");
        if (expectedClassStructure.hasProperty("constructors")) {
            JSONArray expectedConstructors = expectedClassStructure.getPropertyAsJsonArray("constructors");
            ConstructorTestProvider.checkConstructors(expectedClassName, observedClass, expectedConstructors);
        }
    }

    protected static void checkConstructors(String expectedClassName, Class<?> observedClass, JSONArray expectedConstructors) {
        for (int i = 0; i < expectedConstructors.length(); ++i) {
            JSONObject expectedConstructor = expectedConstructors.getJSONObject(i);
            JSONArray expectedParameters = ConstructorTestProvider.getExpectedJsonProperty(expectedConstructor, "parameters");
            JSONArray expectedModifiers = ConstructorTestProvider.getExpectedJsonProperty(expectedConstructor, "modifiers");
            JSONArray expectedAnnotations = ConstructorTestProvider.getExpectedJsonProperty(expectedConstructor, "annotations");
            boolean strictParameterOrder = ConstructorTestProvider.getExpectedJsonBooleanProperty(expectedConstructor, "strictOrder");
            boolean parametersAreRight = false;
            boolean modifiersAreRight = false;
            boolean annotationsAreRight = false;
            for (Constructor<?> observedConstructor : observedClass.getDeclaredConstructors()) {
                Class<?>[] observedParameters = observedConstructor.getParameterTypes();
                String[] observedModifiers = Modifier.toString(observedConstructor.getModifiers()).split(" ");
                Annotation[] observedAnnotations = observedConstructor.getAnnotations();
                parametersAreRight = ConstructorTestProvider.checkParameters(observedParameters, expectedParameters, strictParameterOrder);
                modifiersAreRight = ConstructorTestProvider.checkModifiers(observedModifiers, expectedModifiers);
                annotationsAreRight = ConstructorTestProvider.checkAnnotations(observedAnnotations, expectedAnnotations);
                if (parametersAreRight && modifiersAreRight && annotationsAreRight) break;
            }
            ConstructorTestProvider.checkConstructorCorrectness(expectedClassName, expectedParameters, parametersAreRight, modifiersAreRight, annotationsAreRight);
        }
    }

    private static void checkConstructorCorrectness(String expectedClassName, JSONArray expectedParameters, boolean parametersAreCorrect, boolean modifiersAreCorrect, boolean annotationsAreCorrect) {
        String parameters = ConstructorTestProvider.describeParameters(expectedParameters);
        if (!parametersAreCorrect) {
            throw Messages.localizedFailure("structural.constructor.parameters", expectedClassName, parameters);
        }
        if (!modifiersAreCorrect) {
            throw Messages.localizedFailure("structural.constructor.modifiers", expectedClassName, parameters);
        }
        if (!annotationsAreCorrect) {
            throw Messages.localizedFailure("structural.constructor.annotations", expectedClassName, parameters);
        }
    }
}

