/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.jupiter;

import de.tum.in.test.api.localization.UseLocale;
import java.util.Locale;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

@API(status=API.Status.INTERNAL)
public class JupiterLocaleExtension
implements BeforeAllCallback,
AfterAllCallback {
    private static final String OLD_LOCALE_KEY = "old-locale";

    public void beforeAll(ExtensionContext context) throws Exception {
        Optional annot = AnnotationSupport.findAnnotation((Optional)context.getElement(), UseLocale.class);
        if (annot.isEmpty()) {
            return;
        }
        this.getStore(context).put((Object)OLD_LOCALE_KEY, (Object)Locale.getDefault());
        Locale newLocale = new Locale(((UseLocale)annot.get()).value());
        Locale.setDefault(newLocale);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        Locale oldLocale = (Locale)this.getStore(context).remove((Object)OLD_LOCALE_KEY, Locale.class);
        if (oldLocale != null) {
            Locale.setDefault(oldLocale);
        }
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context.getElement()}));
    }
}

