/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.jqwik;

import de.tum.in.test.api.localization.Messages;
import de.tum.in.test.api.localization.UseLocale;
import java.lang.annotation.AnnotationFormatError;
import java.util.Locale;
import java.util.Optional;
import net.jqwik.api.lifecycle.AroundContainerHook;
import net.jqwik.api.lifecycle.ContainerLifecycleContext;
import org.apiguardian.api.API;
import org.junit.platform.commons.support.AnnotationSupport;

@API(status=API.Status.INTERNAL)
public class JqwikLocaleExtension
implements AroundContainerHook {
    private Locale oldLocale;

    public int proximity() {
        return -20;
    }

    public void beforeContainer(ContainerLifecycleContext context) {
        Optional annot = AnnotationSupport.findAnnotation((Optional)context.optionalElement(), UseLocale.class);
        if (annot.isEmpty()) {
            return;
        }
        if (this.oldLocale != null) {
            throw new AnnotationFormatError(Messages.localized("jqwik.duplicate_locale_extension_failure", new Object[0]));
        }
        this.oldLocale = Locale.getDefault();
        Locale newLocale = new Locale(((UseLocale)annot.get()).value());
        Locale.setDefault(newLocale);
    }

    public void afterContainer(ContainerLifecycleContext context) {
        if (this.oldLocale != null) {
            Locale.setDefault(this.oldLocale);
        }
    }
}

