/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.io;

import de.tum.in.test.api.context.AresContext;
import de.tum.in.test.api.context.TestContext;
import de.tum.in.test.api.internal.ConfigurationUtils;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL)
public final class AresIOContext
extends AresContext {
    private final boolean mirrorOutput;
    private final long maxStdOut;

    private AresIOContext(TestContext testContext, boolean mirrorOutput, long maxStdOut) {
        super(testContext);
        this.mirrorOutput = mirrorOutput;
        this.maxStdOut = maxStdOut;
    }

    public boolean mirrorOutput() {
        return this.mirrorOutput;
    }

    public long maxStdOut() {
        return this.maxStdOut;
    }

    public static AresIOContext from(TestContext testContext) {
        boolean mirrorOutput = ConfigurationUtils.shouldMirrorOutput(testContext);
        long maxStdOut = ConfigurationUtils.getMaxStandardOutput(testContext);
        return new AresIOContext(testContext, mirrorOutput, maxStdOut);
    }
}

