/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.dynamic;

import de.tum.in.test.api.dynamic.Check;
import de.tum.in.test.api.dynamic.Checkable;
import de.tum.in.test.api.dynamic.DynamicClass;
import de.tum.in.test.api.localization.Messages;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(status=API.Status.MAINTAINED)
public class DynamicMethod<T>
implements Checkable {
    static final Collector<CharSequence, ?, String> JOIN_PARAMS = Collectors.joining(", ", "(", ")");
    private final DynamicClass<?> owner;
    private final String name;
    private final DynamicClass<?>[] parameters;
    private final DynamicClass<T> returnType;
    private Method m;

    public DynamicMethod(DynamicClass<?> dClass, Class<T> dynamicableReturn, String mName, Object ... dynamicableParams) {
        this(dClass, DynamicClass.toDynamic(dynamicableReturn), mName, dynamicableParams);
    }

    public DynamicMethod(DynamicClass<?> dClass, DynamicClass<T> dynamicableReturn, String mName, Object ... dynamicableParams) {
        this.owner = Objects.requireNonNull(dClass);
        this.name = Objects.requireNonNull(mName);
        this.returnType = Objects.requireNonNull(dynamicableReturn);
        this.parameters = DynamicClass.toDynamic(Objects.requireNonNull(dynamicableParams));
    }

    public Method toMethod() {
        if (this.m == null) {
            try {
                this.m = this.owner.toClass().getDeclaredMethod(this.name, DynamicClass.resolveAll(this.parameters));
                this.m.trySetAccessible();
                if (!this.returnType.toClass().isAssignableFrom(this.m.getReturnType())) {
                    throw Messages.localizedFailure("dynamics.method.return", this, this.returnType);
                }
            }
            catch (NoSuchMethodException e) {
                throw Messages.localizedFailure(e, "dynamics.method.not_found", this.returnType, this);
            }
        }
        return this.m;
    }

    @Override
    public boolean exists() {
        if (this.m == null) {
            try {
                this.m = this.owner.toClass().getDeclaredMethod(this.name, DynamicClass.resolveAll(this.parameters));
                this.m.trySetAccessible();
                if (!this.returnType.toClass().isAssignableFrom(this.m.getReturnType())) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public T invokeOn(Object o, Object ... params) {
        try {
            return this.returnType.cast(this.toMethod().invoke(o, params));
        }
        catch (NullPointerException e) {
            throw Messages.localizedFailure(e, "dynamics.method.null", this);
        }
        catch (IllegalAccessException e) {
            throw Messages.localizedFailure(e, "dynamics.method.access", this);
        }
        catch (IllegalArgumentException e) {
            throw Messages.localizedFailure(e, "dynamics.method.arguments", this, DynamicMethod.descArgs(params), o.getClass().getCanonicalName());
        }
        catch (InvocationTargetException e) {
            return (T)DynamicClass.rethrowUnchecked(e.getCause());
        }
        catch (ClassCastException e) {
            throw Messages.localizedFailure(e, "dynamics.method.cast", this, this.returnType);
        }
    }

    public T invokeStatic(Object ... params) {
        if (!Modifier.isStatic(this.toMethod().getModifiers())) {
            throw Messages.localizedFailure("dynamics.method.static", this);
        }
        return this.invokeOn(null, params);
    }

    public String toString() {
        return this.owner.toString() + "." + this.signature();
    }

    public String signature() {
        return this.name + DynamicMethod.descParams(this.parameters);
    }

    public static String signatureOf(Method method) {
        return method.getName() + DynamicMethod.descParams(DynamicClass.toDynamic(method.getParameterTypes()));
    }

    public static String[] signatureOfAll(Method ... methods) {
        return (String[])Arrays.stream(methods).map(DynamicMethod::signatureOf).toArray(String[]::new);
    }

    public static String[] signatureOfAll(DynamicMethod<?> ... methods) {
        return (String[])Arrays.stream(methods).map(DynamicMethod::signature).toArray(String[]::new);
    }

    public static String[] signatureOfAll(Collection<Method> methods) {
        return (String[])methods.stream().map(DynamicMethod::signatureOf).toArray(String[]::new);
    }

    public static <T> String[] signatureOfAll(T methods) {
        return (String[])((Collection)methods).stream().map(DynamicMethod::signature).toArray(String[]::new);
    }

    public static String descArgs(Object ... args) {
        return Arrays.stream(args).map(x -> x == null ? null : x.getClass().getCanonicalName()).collect(JOIN_PARAMS);
    }

    public static String descParams(DynamicClass<?> ... params) {
        return Arrays.stream(params).map(DynamicClass::getName).collect(JOIN_PARAMS);
    }

    @Override
    public void check(Check ... checks) {
        int modifiers = this.toMethod().getModifiers();
        for (Check check : checks) {
            check.checkModifiers(modifiers, () -> Messages.localized("dynamics.method.name", this));
        }
    }
}

