/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.util;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class DelayedFilter<T>
implements Predicate<T> {
    private final Predicate<T> original;
    private final int delay;
    private final boolean[] buffer;
    private int pos;
    private boolean hasNotBeenTrue = true;
    private boolean hasNotBeenFalse = true;
    private boolean lastValue;

    public DelayedFilter(int delay, Predicate<T> original, boolean startValue) {
        this.original = Objects.requireNonNull(original);
        if (delay <= 0) {
            throw new IllegalArgumentException("invalid delay: " + delay);
        }
        this.delay = delay;
        this.buffer = new boolean[delay];
        this.lastValue = startValue;
        Arrays.fill(this.buffer, startValue);
    }

    @Override
    public boolean test(T t) {
        this.lastValue = this.buffer[this.pos];
        this.updateWithNewValue(this.original.test(t));
        return this.lastValue;
    }

    private void updateWithNewValue(boolean newValue) {
        this.buffer[this.pos] = newValue;
        this.pos = this.nextPos();
        if (this.hasNotBeenTrue && newValue) {
            this.hasNotBeenTrue = false;
        } else if (this.hasNotBeenFalse && !newValue) {
            this.hasNotBeenFalse = false;
        }
    }

    public boolean lastValue() {
        return this.lastValue;
    }

    public boolean hasBeenTrue() {
        return !this.hasNotBeenTrue;
    }

    public boolean hasBeenFalse() {
        return !this.hasNotBeenFalse;
    }

    private int nextPos() {
        return (this.pos + 1) % this.delay;
    }
}

