/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.structural;

import de.tum.in.test.api.localization.Messages;
import de.tum.in.test.api.structural.StructuralTestProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicTest;

@API(status=API.Status.STABLE)
public abstract class AttributeTestProvider
extends StructuralTestProvider {
    protected DynamicContainer generateTestsForAllClasses() throws URISyntaxException {
        ArrayList<DynamicTest> tests = new ArrayList<DynamicTest>();
        if (structureOracleJSON == null) {
            throw AttributeTestProvider.failure("The AttributeTest test can only run if the structural oracle (test.json) is present. If you do not provide it, delete AttributeTest.java!");
        }
        for (int i = 0; i < structureOracleJSON.length(); ++i) {
            JSONObject expectedClassJSON = structureOracleJSON.getJSONObject(i);
            if (!expectedClassJSON.has("class") || !expectedClassJSON.has("attributes") && !expectedClassJSON.has("enumValues")) continue;
            JSONObject expectedClassPropertiesJSON = expectedClassJSON.getJSONObject("class");
            String expectedClassName = expectedClassPropertiesJSON.getString("name");
            String expectedPackageName = expectedClassPropertiesJSON.getString("package");
            StructuralTestProvider.ExpectedClassStructure expectedClassStructure = new StructuralTestProvider.ExpectedClassStructure(expectedClassName, expectedPackageName, expectedClassJSON);
            tests.add(DynamicTest.dynamicTest((String)("testAttributes[" + expectedClassName + "]"), () -> AttributeTestProvider.testAttributes(expectedClassStructure)));
        }
        if (tests.isEmpty()) {
            throw AttributeTestProvider.failure("No tests for attributes available in the structural oracle (test.json). Either provide attributes information or delete AttributeTest.java!");
        }
        return DynamicContainer.dynamicContainer((String)this.getClass().getName(), (URI)new URI(this.getClass().getName()), tests.stream());
    }

    protected static void testAttributes(StructuralTestProvider.ExpectedClassStructure expectedClassStructure) {
        String expectedClassName = expectedClassStructure.getExpectedClassName();
        Class<?> observedClass = AttributeTestProvider.findClassForTestType(expectedClassStructure, "attribute");
        if (expectedClassStructure.hasProperty("attributes")) {
            JSONArray expectedAttributes = expectedClassStructure.getPropertyAsJsonArray("attributes");
            AttributeTestProvider.checkAttributes(expectedClassName, observedClass, expectedAttributes);
        }
        if (expectedClassStructure.hasProperty("enumValues")) {
            JSONArray expectedEnumValues = expectedClassStructure.getPropertyAsJsonArray("enumValues");
            AttributeTestProvider.checkEnumValues(expectedClassName, observedClass, expectedEnumValues);
        }
    }

    protected static void checkAttributes(String expectedClassName, Class<?> observedClass, JSONArray expectedAttributes) {
        for (int i = 0; i < expectedAttributes.length(); ++i) {
            JSONObject expectedAttribute = expectedAttributes.getJSONObject(i);
            String expectedName = expectedAttribute.getString("name");
            String expectedTypeName = expectedAttribute.getString("type");
            JSONArray expectedModifiers = AttributeTestProvider.getExpectedJsonProperty(expectedAttribute, "modifiers");
            JSONArray expectedAnnotations = AttributeTestProvider.getExpectedJsonProperty(expectedAttribute, "annotations");
            boolean nameIsCorrect = false;
            boolean typeIsCorrect = false;
            boolean modifiersAreCorrect = false;
            boolean annotationsAreCorrect = false;
            for (Field observedAttribute : observedClass.getDeclaredFields()) {
                if (!expectedName.equals(observedAttribute.getName())) continue;
                nameIsCorrect = true;
                typeIsCorrect = AttributeTestProvider.checkExpectedType(observedAttribute.getType(), observedAttribute.getGenericType(), expectedTypeName);
                modifiersAreCorrect = AttributeTestProvider.checkModifiers(Modifier.toString(observedAttribute.getModifiers()).split(" "), expectedModifiers);
                annotationsAreCorrect = AttributeTestProvider.checkAnnotations(observedAttribute.getAnnotations(), expectedAnnotations);
                if (typeIsCorrect && modifiersAreCorrect && annotationsAreCorrect) break;
            }
            AttributeTestProvider.checkAttributeCorrectness(nameIsCorrect, typeIsCorrect, modifiersAreCorrect, annotationsAreCorrect, expectedName, expectedClassName);
        }
    }

    private static void checkAttributeCorrectness(boolean nameIsCorrect, boolean typeIsCorrect, boolean modifiersAreCorrect, boolean annotationsAreCorrect, String expectedName, String expectedClassName) {
        if (!nameIsCorrect) {
            throw Messages.localizedFailure("structural.attribute.name", expectedName, expectedClassName);
        }
        if (!typeIsCorrect) {
            throw Messages.localizedFailure("structural.attribute.type", expectedName, expectedClassName);
        }
        if (!modifiersAreCorrect) {
            throw Messages.localizedFailure("structural.attribute.modifiers", expectedName, expectedClassName);
        }
        if (!annotationsAreCorrect) {
            throw Messages.localizedFailure("structural.attribute.annotations", expectedName, expectedClassName);
        }
    }

    protected static void checkEnumValues(String expectedClassName, Class<?> observedClass, JSONArray expectedEnumValues) {
        if (!observedClass.isEnum()) {
            throw Messages.localizedFailure("structural.attribute.noEnumConstants", expectedClassName);
        }
        Enum[] observedEnumValues = (Enum[])observedClass.getEnumConstants();
        Set observedEnumNames = Stream.of(observedEnumValues).map(Enum::name).collect(Collectors.toSet());
        Set expectedEnumNames = IntStream.range(0, expectedEnumValues.length()).mapToObj(arg_0 -> ((JSONArray)expectedEnumValues).getString(arg_0)).collect(Collectors.toSet());
        Optional<String> missing = expectedEnumNames.stream().filter(Predicate.not(observedEnumNames::contains)).findFirst();
        missing.ifPresent(missingName -> Assertions.fail((String)Messages.localized("structural.attribute.missingEnumConstants", expectedClassName, missingName)));
        Optional<String> unexpected = observedEnumNames.stream().filter(Predicate.not(expectedEnumNames::contains)).findFirst();
        unexpected.ifPresent(unexpectedName -> Assertions.fail((String)Messages.localized("structural.attribute.unexpectedEnumConstants", expectedClassName, unexpectedName)));
    }
}

