/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal.sanitization;

import de.tum.in.test.api.internal.sanitization.MessageTransformer;
import de.tum.in.test.api.internal.sanitization.SanitizationUtils;
import de.tum.in.test.api.internal.sanitization.SpecificThrowableSanitizer;
import de.tum.in.test.api.internal.sanitization.ThrowableInfo;
import java.util.Set;

enum ExceptionInInitializerErrorSanitizer implements SpecificThrowableSanitizer
{
    INSTANCE;

    private final Set<Class<? extends Throwable>> types = Set.of(ExceptionInInitializerError.class);

    @Override
    public boolean canSanitize(Throwable t) {
        return this.types.contains(t.getClass());
    }

    @Override
    public Throwable sanitize(Throwable t, MessageTransformer messageTransformer) {
        ExceptionInInitializerError eiie = (ExceptionInInitializerError)t;
        Throwable exception = eiie.getException();
        ThrowableInfo info = ThrowableInfo.getEssentialInfosSafeFrom(t);
        info.setCause(exception);
        info.sanitize();
        String newMessage = messageTransformer.apply(info);
        ExceptionInInitializerError newEiie = newMessage != null && !newMessage.isEmpty() ? new ExceptionInInitializerError(newMessage) : (exception != null ? new ExceptionInInitializerError(info.getCause()) : new ExceptionInInitializerError());
        SanitizationUtils.copyThrowableInfoSafe(info, (Throwable)newEiie);
        return newEiie;
    }
}

