/*
 * Decompiled with CFR 0.152.
 */
package de.tum.ei.lkn.eces.webgraphgui.color;

public class RGBColor {
    private int red = 0;
    private int green = 0;
    private int blue = 0;

    public boolean setRGB(int newRed, int newGreen, int newBlue) {
        boolean inBounds = true;
        if (newRed <= 0) {
            this.red = 0;
            inBounds = false;
        } else if (newRed >= 255) {
            this.red = 255;
            inBounds = false;
        } else {
            this.red = newRed;
        }
        if (newGreen <= 0) {
            this.green = 0;
            inBounds = false;
        } else if (newGreen >= 255) {
            this.green = 255;
            inBounds = false;
        } else {
            this.green = newGreen;
        }
        if (newBlue <= 0) {
            this.blue = 0;
            inBounds = false;
        } else if (newBlue >= 255) {
            this.blue = 255;
            inBounds = false;
        } else {
            this.blue = newBlue;
        }
        return inBounds;
    }

    public static String gray() {
        return RGBColor.returnRGBString(120, 120, 120);
    }

    public String returnRGB() {
        return "rgb(" + this.red + "," + this.green + "," + this.blue + ")";
    }

    public static String returnRGBString(int red, int green, int blue) {
        String returnString = "rgb(";
        returnString = red <= 0 ? returnString + "0" : (red >= 255 ? returnString + "255" : returnString + Integer.toString(red));
        returnString = returnString + ",";
        returnString = green <= 0 ? returnString + "0" : (green >= 255 ? returnString + "255" : returnString + Integer.toString(green));
        returnString = returnString + ",";
        returnString = blue <= 0 ? returnString + "0" : (blue >= 255 ? returnString + "255" : returnString + Integer.toString(blue));
        returnString = returnString + ")";
        return returnString;
    }

    public static String percentToColor(double percent) {
        if ((percent *= 100.0) < 0.0) {
            return RGBColor.returnRGBString(0, 255, 0);
        }
        if (percent < 50.0) {
            return RGBColor.returnRGBString((int)(255.0 * percent * 2.0 / 100.0), 255, 0);
        }
        if (percent < 100.0) {
            return RGBColor.returnRGBString(255, 255 - (int)(255.0 * (percent - 50.0) * 2.0 / 100.0), 0);
        }
        return RGBColor.returnRGBString(255, 0, 0);
    }
}

