/*
 * Decompiled with CFR 0.152.
 */
package de.tum.ei.lkn.eces.webgraphgui;

import de.tum.ei.lkn.eces.core.Component;
import de.tum.ei.lkn.eces.core.ComponentStatus;
import de.tum.ei.lkn.eces.core.Controller;
import de.tum.ei.lkn.eces.core.Entity;
import de.tum.ei.lkn.eces.core.Mapper;
import de.tum.ei.lkn.eces.core.RootSystem;
import de.tum.ei.lkn.eces.core.annotations.ComponentBelongsTo;
import de.tum.ei.lkn.eces.core.annotations.ComponentStateIs;
import de.tum.ei.lkn.eces.graph.Edge;
import de.tum.ei.lkn.eces.graph.Graph;
import de.tum.ei.lkn.eces.graph.Node;
import de.tum.ei.lkn.eces.graph.mappers.EdgeMapper;
import de.tum.ei.lkn.eces.graph.mappers.GraphMapper;
import de.tum.ei.lkn.eces.webgraphgui.NettyInboundHandler;
import de.tum.ei.lkn.eces.webgraphgui.color.ColoringSystem;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;

@ComponentBelongsTo(system=WebGraphGuiSystem.class)
public class WebGraphGuiSystem
extends RootSystem {
    private int port;
    private EventLoopGroup bossGroup = new NioEventLoopGroup();
    private EventLoopGroup workerGroup = new NioEventLoopGroup();
    private ServerBootstrap bootstr = new ServerBootstrap();
    private NettyInboundHandler myInboundHandler;
    private Mapper<Edge> edgeMapper;
    private Mapper<Graph> graphMapper;
    private ColoringSystem myColSys;

    public WebGraphGuiSystem(Controller controller, ColoringSystem colSys) {
        this(controller, colSys, 80);
    }

    public WebGraphGuiSystem(Controller controller, int port) {
        super(controller);
        this.port = port;
        this.myColSys = null;
        this.myInboundHandler = new NettyInboundHandler(controller);
        this.edgeMapper = new EdgeMapper(controller);
        this.graphMapper = new GraphMapper(controller);
        try {
            this.run();
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception caught while calling run() in WebGraphGuiSystem, shutting webserver down. ERROR: " + e));
            this.shutdownServerGracefully();
        }
    }

    public WebGraphGuiSystem(Controller controller, ColoringSystem colSys, int port) {
        super(controller);
        this.port = port;
        this.myColSys = colSys;
        this.myInboundHandler = new NettyInboundHandler(controller, colSys);
        this.edgeMapper = new EdgeMapper(controller);
        try {
            this.run();
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception caught while calling run() in WebGraphGuiSystem, shutting webserver down. ERROR: " + e));
            this.shutdownServerGracefully();
        }
    }

    public void run() throws Exception {
        ((ServerBootstrap)((ServerBootstrap)this.bootstr.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
                p.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
                p.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
                p.addLast("handler", (ChannelHandler)WebGraphGuiSystem.this.myInboundHandler);
            }
        }).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.bootstr.bind(this.port).sync();
    }

    public void shutdownServerGracefully() {
        this.workerGroup.shutdownGracefully();
        this.bossGroup.shutdownGracefully();
    }

    @ComponentStateIs(State=ComponentStatus.New)
    public void addNewNode(Node newNode) {
        this.logger.debug((Object)("addNewNode; ID: " + newNode.getEntity().getId()));
        this.myInboundHandler.componentStateNode(newNode, "New");
    }

    @ComponentStateIs(State=ComponentStatus.Updated)
    public void updatedNode(Node newNode) {
        this.logger.debug((Object)("updateNode; ID: " + newNode.getEntity().getId()));
        this.myInboundHandler.componentStateNode(newNode, "Updated");
    }

    @ComponentStateIs(State=ComponentStatus.Destroyed)
    public void nodeDestroyed(Node newNode) {
        this.logger.debug((Object)("nodeDestroyed; ID: " + newNode.getEntity().getId()));
        this.myInboundHandler.componentStateNode(newNode, "Destroyed");
    }

    @ComponentStateIs(State=ComponentStatus.New)
    public void addNewEdge(Edge newEdge) {
        this.logger.debug((Object)("addNewEdge; ID: " + newEdge.getEntity().getId()));
        this.myInboundHandler.componentStateEdge(newEdge, "New");
        this.myInboundHandler.sendColorOfEdge(newEdge);
    }

    @ComponentStateIs(State=ComponentStatus.Updated)
    public void updatedEdge(Edge newEdge) {
        this.logger.debug((Object)("updatedEdge; ID: " + newEdge.getEntity().getId()));
        this.myInboundHandler.componentStateEdge(newEdge, "Updated");
    }

    @ComponentStateIs(State=ComponentStatus.Destroyed)
    public void edgeDestroyed(Edge newEdge) {
        this.logger.debug((Object)("edgeDestroyed; ID: " + newEdge.getEntity().getId()));
        this.myInboundHandler.componentStateEdge(newEdge, "Destroyed");
    }

    @ComponentStateIs(State=ComponentStatus.New)
    public void addNewGraph(Graph newGraph) {
        this.myInboundHandler.addGraph(newGraph);
    }

    @ComponentStateIs(State=ComponentStatus.Updated)
    public void updatedComponent(Component updatedComponent) {
        this.logger.debug((Object)("updatedActiveEntity: " + updatedComponent.getClass().getSimpleName()));
        Entity updatedEntity = updatedComponent.getEntity();
        long updatedEntityId = updatedEntity.getId();
        Edge edgeOfEntity = (Edge)this.edgeMapper.get(updatedEntity);
        this.myInboundHandler.updatedActiveEntity(updatedEntityId);
        if (edgeOfEntity != null) {
            this.myInboundHandler.sendColorOfEdge(edgeOfEntity);
        }
    }
}

