/*
 * Decompiled with CFR 0.152.
 */
package de.tum.ei.lkn.eces.webgraphgui;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelProgressiveFuture;
import io.netty.channel.ChannelProgressiveFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.activation.MimetypesFileTypeMap;
import org.apache.log4j.Logger;

public class NettyHttpFileHandler {
    private static final Logger logger = Logger.getLogger(NettyHttpFileHandler.class);
    public static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String HTTP_DATE_GMT_TIMEZONE = "GMT";
    public static final int HTTP_CACHE_SECONDS = 60;
    private static final Object _lock = new Object();
    protected static MimetypesFileTypeMap mimeTypesMap;
    private static final Pattern INSECURE_URI;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NettyHttpFileHandler() {
        Object object = _lock;
        synchronized (object) {
            if (mimeTypesMap == null) {
                InputStream is = this.getClass().getResourceAsStream("/server.mime.types");
                if (is != null) {
                    mimeTypesMap = new MimetypesFileTypeMap(is);
                } else {
                    logger.debug((Object)"Cannot load mime types!");
                }
            }
        }
    }

    public void sendFile(ChannelHandlerContext ctx, FullHttpRequest req) throws Exception {
        ChannelFuture lastContentFuture;
        ChannelFuture sendFileFuture;
        RandomAccessFile raf;
        long fileLastModifiedSeconds;
        SimpleDateFormat dateFormatter;
        Date ifModifiedSinceDate;
        long ifModifiedSinceDateSeconds;
        String uri = req.getUri();
        logger.debug((Object)("uri: " + uri));
        String sanitUri = this.sanitizeUri(uri);
        if (sanitUri == null) {
            this.sendError(ctx, HttpResponseStatus.FORBIDDEN);
            return;
        }
        File file = this.getResourceAsFile(sanitUri);
        if (file == null || !file.exists() || file.isHidden() || file.isDirectory()) {
            this.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return;
        }
        if (!file.isFile()) {
            this.sendError(ctx, HttpResponseStatus.FORBIDDEN);
            return;
        }
        String ifModifiedSince = req.headers().get("If-Modified-Since");
        if (ifModifiedSince != null && !ifModifiedSince.isEmpty() && (ifModifiedSinceDateSeconds = (ifModifiedSinceDate = (dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US)).parse(ifModifiedSince)).getTime() / 1000L) == (fileLastModifiedSeconds = file.lastModified() / 1000L)) {
            this.sendNotModified(ctx);
            return;
        }
        try {
            raf = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException ignore) {
            this.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return;
        }
        long fileLength = raf.length();
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        HttpHeaders.setContentLength((HttpMessage)response, (long)fileLength);
        this.setContentTypeHeader((HttpResponse)response, sanitUri);
        this.setDateAndCacheHeaders((HttpResponse)response, file);
        if (HttpHeaders.isKeepAlive((HttpMessage)req)) {
            response.headers().set("Connection", (Object)"keep-alive");
        }
        ctx.write((Object)response);
        if (ctx.pipeline().get(SslHandler.class) == null) {
            sendFileFuture = ctx.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, fileLength), (ChannelPromise)ctx.newProgressivePromise());
            lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        } else {
            lastContentFuture = sendFileFuture = ctx.write((Object)new HttpChunkedInput((ChunkedInput)new ChunkedFile(raf, 0L, fileLength, 8192)), (ChannelPromise)ctx.newProgressivePromise());
        }
        sendFileFuture.addListener((GenericFutureListener)new ChannelProgressiveFutureListener(){

            public void operationProgressed(ChannelProgressiveFuture future, long progress, long total) {
            }

            public void operationComplete(ChannelProgressiveFuture future) {
            }
        });
        if (!HttpHeaders.isKeepAlive((HttpMessage)req)) {
            lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void sendRedirect(ChannelHandlerContext ctx, String newUri) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FOUND);
        response.headers().set("Location", (Object)newUri);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)("Failure: " + status + "\r\n"), (Charset)CharsetUtil.UTF_8));
        response.headers().set("Content-Type", (Object)"text/plain; charset=UTF-8");
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void sendNotModified(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_MODIFIED);
        this.setDateHeader((FullHttpResponse)response);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void setDateHeader(FullHttpResponse response) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        response.headers().set("Date", (Object)dateFormatter.format(time.getTime()));
    }

    public void setDateAndCacheHeaders(HttpResponse response, File fileToCache) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        response.headers().set("Date", (Object)dateFormatter.format(time.getTime()));
        ((Calendar)time).add(13, 60);
        response.headers().set("Expires", (Object)dateFormatter.format(time.getTime()));
        response.headers().set("Cache-Control", (Object)"private, max-age=60");
        response.headers().set("Last-Modified", (Object)dateFormatter.format(new Date(fileToCache.lastModified())));
    }

    public void setContentTypeHeader(HttpResponse response, String filename) {
        String filetype;
        String[] splitarray = filename.split("\\.");
        switch (filetype = splitarray[splitarray.length - 1]) {
            case "js": {
                response.headers().set("Content-Type", (Object)"application/javascript");
                break;
            }
            case "css": {
                response.headers().set("Content-Type", (Object)"text/css");
                break;
            }
            case "ico": {
                response.headers().set("Content-Type", (Object)"image/x-icon");
                break;
            }
            default: {
                response.headers().set("Content-Type", (Object)"text/html");
            }
        }
    }

    public void sendHttpResponse(ChannelHandlerContext ctx, FullHttpRequest req, FullHttpResponse res) {
        if (res.getStatus().code() != 200) {
            ByteBuf f = Unpooled.copiedBuffer((CharSequence)res.getStatus().toString(), (Charset)CharsetUtil.UTF_8);
            res.content().clear();
            res.content().writeBytes(f);
            f.release();
        }
        HttpHeaders.setContentLength((HttpMessage)res, (long)res.content().readableBytes());
        ChannelFuture f1 = ctx.channel().writeAndFlush((Object)res);
        if (!HttpHeaders.isKeepAlive((HttpMessage)req) || res.getStatus().code() != 200) {
            f1.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public String sanitizeUri(String uri) {
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        if (uri.isEmpty() || uri.charAt(0) != '/') {
            return null;
        }
        if (uri.contains(File.separator + '.') || uri.contains('.' + File.separator) || uri.charAt(0) == '.' || uri.charAt(uri.length() - 1) == '.' || INSECURE_URI.matcher(uri).matches()) {
            return null;
        }
        return uri;
    }

    public File getResourceAsFile(String resourcePath) {
        try {
            InputStream in;
            if (resourcePath.length() > 0 && resourcePath.charAt(0) != '/') {
                resourcePath = "/" + resourcePath;
            }
            if ((in = this.getClass().getResourceAsStream(resourcePath)) == null) {
                return null;
            }
            File tempFile = File.createTempFile(String.valueOf(in.hashCode()), ".tmp");
            tempFile.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(tempFile);){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            return tempFile;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        INSECURE_URI = Pattern.compile(".*[<>&\"].*");
    }
}

