/*
 * Decompiled with CFR 0.152.
 */
package de.tum.ei.lkn.eces.network.color;

import de.tum.ei.lkn.eces.core.Controller;
import de.tum.ei.lkn.eces.core.Entity;
import de.tum.ei.lkn.eces.core.Mapper;
import de.tum.ei.lkn.eces.graph.Edge;
import de.tum.ei.lkn.eces.network.Link;
import de.tum.ei.lkn.eces.network.Rate;
import de.tum.ei.lkn.eces.network.ToNetwork;
import de.tum.ei.lkn.eces.network.mappers.LinkMapper;
import de.tum.ei.lkn.eces.network.mappers.RateMapper;
import de.tum.ei.lkn.eces.network.mappers.ToNetworkMapper;
import de.tum.ei.lkn.eces.webgraphgui.color.ColoringScheme;
import de.tum.ei.lkn.eces.webgraphgui.color.RGBColor;

public class RateColoring
implements ColoringScheme {
    private Mapper<Rate> rateMapper;
    private Mapper<ToNetwork> toNetworkMapper;
    private Mapper<Link> linkMapper;
    private double maxRate;

    public RateColoring(Controller controller) {
        this.rateMapper = new RateMapper(controller);
        this.toNetworkMapper = new ToNetworkMapper(controller);
        this.linkMapper = new LinkMapper(controller);
        this.maxRate = 0.0;
    }

    @Override
    public String getColor(Edge edge) {
        Entity networkEntity;
        Link link;
        Rate rate = (Rate)this.rateMapper.get(edge.getEntity());
        if (rate != null) {
            this.updateMaxRate(rate.getRate());
            return RGBColor.percentToColor(1.0 - rate.getRate() / this.maxRate);
        }
        if (this.toNetworkMapper.isIn(edge.getEntity()) && (link = (Link)this.linkMapper.get(networkEntity = ((ToNetwork)this.toNetworkMapper.get(edge.getEntity())).getNetworkEntity())) != null && (rate = (Rate)this.rateMapper.get(link.getLinkEdge().getEntity())) != null) {
            this.updateMaxRate(rate.getRate());
            return RGBColor.percentToColor(1.0 - rate.getRate() / this.maxRate);
        }
        return RGBColor.gray();
    }

    private void updateMaxRate(double rate) {
        this.maxRate = rate > this.maxRate ? rate : this.maxRate;
    }

    @Override
    public boolean isPolling(Edge edge) {
        return true;
    }
}

