/*
 * Decompiled with CFR 0.152.
 */
package de.tum.ei.lkn.eces.network.color;

import de.tum.ei.lkn.eces.core.Controller;
import de.tum.ei.lkn.eces.core.Mapper;
import de.tum.ei.lkn.eces.graph.Edge;
import de.tum.ei.lkn.eces.network.Delay;
import de.tum.ei.lkn.eces.network.Link;
import de.tum.ei.lkn.eces.network.ToNetwork;
import de.tum.ei.lkn.eces.network.mappers.DelayMapper;
import de.tum.ei.lkn.eces.network.mappers.LinkMapper;
import de.tum.ei.lkn.eces.network.mappers.ToNetworkMapper;
import de.tum.ei.lkn.eces.webgraphgui.color.ColoringScheme;
import de.tum.ei.lkn.eces.webgraphgui.color.RGBColor;

public class DelayColoring
implements ColoringScheme {
    private Mapper<Delay> delayMapper;
    private Mapper<ToNetwork> toNetworkMapper;
    private Mapper<Link> linkMapper;
    private double maxDelay;

    public DelayColoring(Controller controller) {
        this.delayMapper = new DelayMapper(controller);
        this.toNetworkMapper = new ToNetworkMapper(controller);
        this.linkMapper = new LinkMapper(controller);
        this.maxDelay = 0.0;
    }

    @Override
    public String getColor(Edge edge) {
        Delay delay = (Delay)this.delayMapper.get(edge.getEntity());
        if (delay != null) {
            this.updateMaxDelay(delay.getDelay());
            return RGBColor.percentToColor(delay.getDelay() / this.maxDelay);
        }
        return RGBColor.gray();
    }

    private void updateMaxDelay(double delay) {
        this.maxDelay = delay > this.maxDelay ? delay : this.maxDelay;
    }

    @Override
    public boolean isPolling(Edge edge) {
        return true;
    }
}

