/*
 * Decompiled with CFR 0.152.
 */
package de.tum.ei.lkn.eces.dnm.color;

import de.tum.ei.lkn.eces.core.Controller;
import de.tum.ei.lkn.eces.dnm.color.AssignedRateColoring;
import de.tum.ei.lkn.eces.dnm.inputmodels.TokenBucketUtilization;
import de.tum.ei.lkn.eces.dnm.mappers.TokenBucketUtilizationMapper;
import de.tum.ei.lkn.eces.graph.Edge;
import de.tum.ei.lkn.eces.webgraphgui.color.ColoringScheme;
import de.tum.ei.lkn.eces.webgraphgui.color.RGBColor;

public class RemainingRateColoring
implements ColoringScheme {
    private Controller controller;
    private AssignedRateColoring assignedRateColoring;

    public RemainingRateColoring(Controller controller) {
        this.controller = controller;
        this.assignedRateColoring = new AssignedRateColoring(controller);
    }

    @Override
    public String getColor(Edge edge) {
        try {
            return RGBColor.percentToColor(this.getUsedRate(edge) / this.assignedRateColoring.getAvailableRate(edge));
        }
        catch (RuntimeException e) {
            return RGBColor.gray();
        }
    }

    private double getUsedRate(Edge edge) {
        if (new TokenBucketUtilizationMapper(this.controller).isIn(edge.getEntity())) {
            return ((TokenBucketUtilization)new TokenBucketUtilizationMapper(this.controller).get(edge.getEntity())).getRate().doubleValue();
        }
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean isPolling(Edge edge) {
        return true;
    }
}

