/*
 * Decompiled with CFR 0.152.
 */
package de.tum.ei.lkn.eces.webgraphgui.examples;

import de.tum.ei.lkn.eces.core.Component;
import de.tum.ei.lkn.eces.core.Controller;
import de.tum.ei.lkn.eces.dnm.DNMSystem;
import de.tum.ei.lkn.eces.dnm.ResidualMode;
import de.tum.ei.lkn.eces.dnm.color.AssignedBufferColoring;
import de.tum.ei.lkn.eces.dnm.color.AssignedRateColoring;
import de.tum.ei.lkn.eces.dnm.color.RemainingBufferColoring;
import de.tum.ei.lkn.eces.dnm.color.RemainingDelayColoring;
import de.tum.ei.lkn.eces.dnm.color.RemainingRateColoring;
import de.tum.ei.lkn.eces.dnm.config.ACModel;
import de.tum.ei.lkn.eces.dnm.config.BurstIncreaseModel;
import de.tum.ei.lkn.eces.dnm.config.CostModel;
import de.tum.ei.lkn.eces.dnm.config.DetServConfig;
import de.tum.ei.lkn.eces.dnm.config.costmodels.functions.Division;
import de.tum.ei.lkn.eces.dnm.config.costmodels.functions.LowerLimit;
import de.tum.ei.lkn.eces.dnm.config.costmodels.functions.Summation;
import de.tum.ei.lkn.eces.dnm.config.costmodels.functions.UpperLimit;
import de.tum.ei.lkn.eces.dnm.config.costmodels.values.Constant;
import de.tum.ei.lkn.eces.dnm.mappers.DetServConfigMapper;
import de.tum.ei.lkn.eces.dnm.proxies.DetServProxy;
import de.tum.ei.lkn.eces.dnm.resourcemanagement.resourceallocation.TBM.TBMDelayRatiosAllocation;
import de.tum.ei.lkn.eces.network.Network;
import de.tum.ei.lkn.eces.network.NetworkNode;
import de.tum.ei.lkn.eces.network.NetworkingSystem;
import de.tum.ei.lkn.eces.network.color.DelayColoring;
import de.tum.ei.lkn.eces.network.color.QueueColoring;
import de.tum.ei.lkn.eces.network.color.RateColoring;
import de.tum.ei.lkn.eces.routing.RoutingSystem;
import de.tum.ei.lkn.eces.routing.algorithms.csp.unicast.larac.LARACAlgorithm;
import de.tum.ei.lkn.eces.routing.pathlist.LastEmbeddingColoring;
import de.tum.ei.lkn.eces.routing.pathlist.PathListColoring;
import de.tum.ei.lkn.eces.routing.pathlist.PathListSystem;
import de.tum.ei.lkn.eces.routing.proxies.PathProxy;
import de.tum.ei.lkn.eces.webgraphgui.WebGraphGuiSystem;
import de.tum.ei.lkn.eces.webgraphgui.color.ColoringScheme;
import de.tum.ei.lkn.eces.webgraphgui.color.ColoringSystem;

public class FullExample {
    public static void main(String[] args) throws InterruptedException {
        Controller controller = new Controller();
        NetworkingSystem myNetworkingSystem = new NetworkingSystem(controller);
        RoutingSystem routingSystem = new RoutingSystem(controller);
        DetServConfig cfg = new DetServConfig(ACModel.TBM, ResidualMode.HIGHEST_SLOPE, BurstIncreaseModel.WORST_CASE_BURST_REAL_RESERVATION, false, (CostModel)new LowerLimit((CostModel)new UpperLimit((CostModel)new Summation(new CostModel[]{new Constant(), new Division((CostModel)new Constant(), (CostModel)new Constant(2.0))}), 2.0), 1.0), (cont, sched) -> new TBMDelayRatiosAllocation(cont));
        new DNMSystem(controller);
        cfg.initCostModel(controller);
        LARACAlgorithm dclcAlgorithm = new LARACAlgorithm(controller);
        dclcAlgorithm.setProxy((PathProxy)new DetServProxy(controller));
        ColoringSystem myColoringSys = new ColoringSystem(controller);
        myColoringSys.addColoringScheme((ColoringScheme)new DelayColoring(controller), "Delay");
        myColoringSys.addColoringScheme((ColoringScheme)new QueueColoring(controller), "Queue sizes");
        myColoringSys.addColoringScheme((ColoringScheme)new RateColoring(controller), "Link rate");
        myColoringSys.addColoringScheme((ColoringScheme)new RemainingRateColoring(controller), "Remaining rate");
        myColoringSys.addColoringScheme((ColoringScheme)new AssignedRateColoring(controller), "Assigned rate");
        myColoringSys.addColoringScheme((ColoringScheme)new RemainingBufferColoring(controller), "Remaining buffer space");
        myColoringSys.addColoringScheme((ColoringScheme)new RemainingDelayColoring(controller), "Remaining delay");
        myColoringSys.addColoringScheme((ColoringScheme)new AssignedBufferColoring(controller), "Assigned buffer space");
        myColoringSys.addColoringScheme((ColoringScheme)new LastEmbeddingColoring(new PathListSystem(controller)), "Last embedded flow");
        myColoringSys.addColoringScheme((ColoringScheme)new PathListColoring(controller), "Amount of paths");
        new WebGraphGuiSystem(controller, myColoringSys, 8080);
        Network network = myNetworkingSystem.createNetwork();
        new DetServConfigMapper(controller).attachComponent((Component)network.getQueueGraph(), (Component)cfg);
        NetworkNode node1 = myNetworkingSystem.createNode(network, "Node1");
        NetworkNode node2 = myNetworkingSystem.createNode(network, "Node2");
        NetworkNode node3 = myNetworkingSystem.createNode(network, "Node3");
        myNetworkingSystem.createLinkWithPriorityScheduling(node1, node2, 1.25E7, 0.0, new double[]{4000.0, 8000.0, 3587.0, 8554.0});
        myNetworkingSystem.createLinkWithPriorityScheduling(node2, node1, 1.25E7, 0.0, new double[]{1258.0, 754.0, 3587.0, 8554.0});
        myNetworkingSystem.createLinkWithPriorityScheduling(node2, node3, 1.25E7, 2.0, new double[]{4000.0, 8000.0, 4000.0, 754.0});
        myNetworkingSystem.createLinkWithPriorityScheduling(node3, node1, 1.25E7, 3.0, new double[]{2547.0, 424.0, 750.0, 1258.0});
        while (true) {
            Thread.sleep(5000L);
        }
    }
}

