/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.wrapper.com;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComThread;
import com.jacob.com.JacobException;
import com.jacob.com.Variant;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.AnalysisEnvironment;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComDispatch;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComException;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComProperty;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComTimeoutException;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.Package;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.Project;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.TestBenchConfiguration;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.TestConfiguration;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.TestEnvironment;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.TestManagement;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.api.ComAnalysisEnvironment;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.api.ComApplication;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.api.ComPackage;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.api.ComProject;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.api.ComTestBenchConfiguration;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.api.ComTestConfiguration;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.api.ComTestEnvironment;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.api.ComTestManagement;
import org.apache.commons.lang.StringUtils;

public class ETComClient
implements ComApplication,
AutoCloseable {
    private ETComDispatch dispatch;
    private boolean releaseDispatch;
    private boolean useTimeout;

    public ETComClient() throws ETComException {
        ETComProperty properties = ETComProperty.getInstance();
        this.initDispatch(properties.getProgId());
        this.waitForConnection(properties.getTimeout());
    }

    public ETComClient(String progId) throws ETComException {
        this.initDispatch(progId);
        this.waitForConnection(120);
    }

    public ETComClient(int timeout) throws ETComException {
        this.initDispatch("ECU-TEST.Application");
        this.waitForConnection(timeout);
    }

    public ETComClient(String progId, int timeout) throws ETComException {
        this.initDispatch(progId);
        this.waitForConnection(timeout);
    }

    private void initDispatch(String progId) throws ETComException {
        ETComProperty properties = ETComProperty.getInstance();
        int timeout = properties.getTimeout();
        if (timeout == 0) {
            this.useTimeout = false;
            this.initSTA(progId);
        } else {
            this.useTimeout = true;
            this.initMTA(progId);
        }
    }

    private void initSTA(String progId) throws ETComException {
        try {
            ComThread.InitSTA();
            ActiveXComponent component = new ActiveXComponent(StringUtils.isEmpty((String)progId) ? "ECU-TEST.Application" : progId);
            this.dispatch = new ETComDispatch(component.getObject(), false);
        }
        catch (JacobException e) {
            throw new ETComException(e.getMessage(), e);
        }
    }

    private void initMTA(String progId) throws ETComException {
        try {
            ComThread.InitMTA();
            this.releaseDispatch = false;
            InitDispatch initDispatch = new InitDispatch(progId);
            InitDispatchExceptionHandler exceptionHandler = new InitDispatchExceptionHandler();
            initDispatch.setUncaughtExceptionHandler(exceptionHandler);
            initDispatch.start();
            int timeout = 120;
            long endTimeMillis = System.currentTimeMillis() + Long.valueOf(120L) * 1000L;
            while (System.currentTimeMillis() < endTimeMillis) {
                if (this.dispatch != null && this.dispatch.isAttached()) {
                    return;
                }
                if (this.releaseDispatch) {
                    throw new ETComException(exceptionHandler.getThrowable());
                }
                Thread.sleep(100L);
            }
            throw new ETComTimeoutException(String.format("Maximum timeout of %d seconds exceeded: COM server not available!", 120));
        }
        catch (InterruptedException e) {
            throw new ETComException(e.getMessage(), e);
        }
    }

    private void waitForConnection(int timeout) throws ETComException {
        long endTimeMillis = System.currentTimeMillis() + Long.valueOf(timeout) * 1000L;
        while (timeout <= 0 || System.currentTimeMillis() < endTimeMillis) {
            try {
                if (this.isApplicationRunning()) {
                    return;
                }
                Thread.sleep(1000L);
            }
            catch (ETComException e) {
                if (e instanceof ETComTimeoutException) {
                    return;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    throw new ETComException(e.getMessage(), e);
                }
            }
            catch (InterruptedException e) {
                throw new ETComException(e.getMessage(), e);
            }
        }
        throw new ETComTimeoutException(String.format("Maximum timeout of %d seconds exceeded: COM server not available!", timeout));
    }

    @Override
    public void close() {
        if (this.useTimeout) {
            this.releaseDispatch = true;
            ComThread.quitMainSTA();
        } else {
            try {
                this.releaseDispatch();
            }
            catch (ETComException eTComException) {
            }
            finally {
                ComThread.Release();
            }
        }
    }

    protected void finalize() throws Throwable {
        if (!this.useTimeout) {
            try {
                this.releaseDispatch();
            }
            finally {
                ComThread.Release();
                super.finalize();
            }
        }
    }

    private void releaseDispatch() throws ETComException {
        if (this.dispatch != null) {
            try {
                this.dispatch.safeRelease();
            }
            catch (JacobException e) {
                throw new ETComException(e.getMessage(), e);
            }
        }
    }

    @Override
    public ComTestEnvironment start() throws ETComException {
        return new TestEnvironment(this.dispatch.performDirectRequest("Start").toDispatch(), this.useTimeout);
    }

    @Override
    public ComTestEnvironment stop() throws ETComException {
        return new TestEnvironment(this.dispatch.performDirectRequest("Stop").toDispatch(), this.useTimeout);
    }

    @Override
    public ComTestEnvironment getTestEnvironment() throws ETComException {
        return new TestEnvironment(this.dispatch.performRequest("GetTestEnvironment").toDispatch(), this.useTimeout);
    }

    @Override
    public ComAnalysisEnvironment getAnalysisEnvironment() throws ETComException {
        return new AnalysisEnvironment(this.dispatch.performRequest("GetAnalysisEnvironment").toDispatch(), this.useTimeout);
    }

    @Override
    public ComTestManagement getTestManagement() throws ETComException {
        return new TestManagement(this.dispatch.performRequest("GetTestManagementModule").toDispatch(), this.useTimeout);
    }

    @Override
    public boolean isApplicationRunning() throws ETComException {
        return this.dispatch.performRequest("IsApplicationRunning").getBoolean();
    }

    @Override
    public String getVersion() throws ETComException {
        return this.dispatch.performRequest("GetVersion").getString();
    }

    @Override
    public String getSetting(String settingName) throws ETComException {
        return this.dispatch.performRequest("GetSetting", new Variant((Object)settingName)).getString();
    }

    @Override
    public boolean quit() throws ETComException {
        return this.dispatch.performRequest("Quit").getBoolean();
    }

    @Override
    public boolean exit() throws ETComException {
        return this.dispatch.performRequest("Exit").getBoolean();
    }

    @Override
    public ComPackage openPackage(String path) throws ETComException {
        return new Package(this.dispatch.performRequest("OpenPackage", new Variant((Object)path)).toDispatch(), this.useTimeout);
    }

    @Override
    public boolean closePackage(String path) throws ETComException {
        return this.dispatch.performRequest("ClosePackage", new Variant((Object)path)).getBoolean();
    }

    public ComProject openProject(String path) throws ETComException {
        return this.openProject(path, false, "");
    }

    @Override
    public ComProject openProject(String path, boolean execInCurrentPkgDir, String filterExpression) throws ETComException {
        return new Project(this.dispatch.performRequest("OpenProject", new Variant((Object)path), new Variant(execInCurrentPkgDir), new Variant((Object)filterExpression)).toDispatch(), this.useTimeout);
    }

    @Override
    public boolean closeProject(String path) throws ETComException {
        return this.dispatch.performRequest("CloseProject", new Variant((Object)path)).getBoolean();
    }

    @Override
    public boolean importProject(String path, String importPath, String importConfigPath, boolean replaceFiles) throws ETComException {
        return this.dispatch.performDirectRequest("ImportProject", new Variant((Object)path), new Variant(replaceFiles), new Variant(false), new Variant((Object)importPath), new Variant((Object)importConfigPath)).getBoolean();
    }

    @Override
    public boolean openTestbenchConfiguration(String path) throws ETComException {
        return this.dispatch.performRequest("OpenTestbenchConfiguration", new Variant((Object)path)).getBoolean();
    }

    @Override
    public boolean openTestConfiguration(String path) throws ETComException {
        return this.dispatch.performRequest("OpenTestConfiguration", new Variant((Object)path)).getBoolean();
    }

    @Override
    public ComTestConfiguration getCurrentTestConfiguration() throws ETComException {
        return new TestConfiguration(this.dispatch.performRequest("GetCurrentTestConfiguration").toDispatch(), this.useTimeout);
    }

    @Override
    public ComTestBenchConfiguration getCurrentTestBenchConfiguration() throws ETComException {
        return new TestBenchConfiguration(this.dispatch.performRequest("GetCurrentTestbenchConfiguration").toDispatch(), this.useTimeout);
    }

    @Override
    public boolean waitForIdle(int timeout) throws ETComException {
        if (timeout == 0) {
            return this.dispatch.performDirectRequest("WaitForIdle").getBoolean();
        }
        return this.dispatch.performDirectRequest("WaitForIdle", new Variant(timeout)).getBoolean();
    }

    private final class InitDispatchExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private Throwable throwable;

        private InitDispatchExceptionHandler() {
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.throwable = e;
            ETComClient.this.releaseDispatch = true;
        }
    }

    private final class InitDispatch
    extends Thread {
        private final String progId;

        InitDispatch(String progId) {
            this.progId = StringUtils.isEmpty((String)progId) ? "ECU-TEST.Application" : progId;
        }

        @Override
        public void run() {
            ActiveXComponent component = null;
            try {
                ComThread.InitMTA();
                component = new ActiveXComponent(this.progId);
                ETComClient.this.dispatch = new ETComDispatch(component.getObject(), true);
                while (!ETComClient.this.dispatch.isAttached()) {
                    InitDispatch.sleep(100L);
                }
                while (!ETComClient.this.releaseDispatch) {
                    InitDispatch.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                if (component != null) {
                    component.safeRelease();
                }
                if (ETComClient.this.dispatch != null) {
                    ETComClient.this.dispatch.safeRelease();
                }
                ComThread.Release();
            }
        }
    }
}

