/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.util.validation;

import de.tracetronic.jenkins.plugins.ecutest.report.junit.Messages;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.AbstractValidator;
import hudson.util.FormValidation;
import org.apache.commons.lang.StringUtils;

public class JUnitValidator
extends AbstractValidator {
    public FormValidation validateUnstableThreshold(String value) {
        FormValidation returnValue = FormValidation.ok();
        if (StringUtils.isBlank((String)value)) {
            returnValue = FormValidation.warning((String)Messages.JUnitPublisher_NoUnstableThreshold());
        } else if (value.contains("$")) {
            returnValue = FormValidation.warning((String)Messages.JUnitPublisher_NoValidatedValue());
        } else if (!this.isPercentageValue(value)) {
            returnValue = FormValidation.error((String)Messages.JUnitPublisher_InvalidPercentage());
        }
        return returnValue;
    }

    public FormValidation validateFailedThreshold(String value) {
        FormValidation returnValue = FormValidation.ok();
        if (StringUtils.isBlank((String)value)) {
            returnValue = FormValidation.warning((String)Messages.JUnitPublisher_NoFailedThreshold());
        } else if (value.contains("$")) {
            returnValue = FormValidation.warning((String)Messages.JUnitPublisher_NoValidatedValue());
        } else if (!this.isPercentageValue(value)) {
            returnValue = FormValidation.error((String)Messages.JUnitPublisher_InvalidPercentage());
        }
        return returnValue;
    }

    private boolean isPercentageValue(String value) {
        try {
            double doubleValue = Double.parseDouble(value);
            return doubleValue <= 100.0 && doubleValue >= 0.0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

