/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.util.validation;

import de.tracetronic.jenkins.plugins.ecutest.test.Messages;
import hudson.util.FormValidation;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;

public abstract class AbstractValidator {
    protected static final String PARAMETER = "$";

    public FormValidation validateTimeout(@QueryParameter String timeout, int defaultTimeout) {
        FormValidation returnValue = FormValidation.ok();
        if (StringUtils.isBlank((String)timeout)) {
            returnValue = FormValidation.warning((String)Messages.Builder_NoTimeout(defaultTimeout));
        } else if (timeout.contains(PARAMETER)) {
            returnValue = FormValidation.warning((String)Messages.Builder_NoValidatedValue());
        } else {
            returnValue = FormValidation.validateNonNegativeInteger((String)timeout);
            if (returnValue.equals(FormValidation.ok()) && Integer.parseInt(timeout) == 0) {
                returnValue = FormValidation.warning((String)Messages.Builder_DisabledTimeout());
            }
        }
        return returnValue;
    }

    protected FormValidation validateRequiredValue(String value) {
        return FormValidation.validateRequired((String)value);
    }

    protected FormValidation validateParameterizedValue(String value) {
        FormValidation returnValue = FormValidation.ok();
        if (!StringUtils.isEmpty((String)value) && value.contains(PARAMETER)) {
            returnValue = FormValidation.warning((String)Messages.Builder_NoValidatedValue());
        }
        return returnValue;
    }

    protected FormValidation validateRequiredParamValue(String value) {
        FormValidation returnValue = FormValidation.ok();
        if (StringUtils.isBlank((String)value)) {
            returnValue = FormValidation.validateRequired((String)value);
        } else if (value.contains(PARAMETER)) {
            returnValue = this.validateParameterizedValue(value);
        }
        return returnValue;
    }

    public FormValidation validatePackageFile(String testFile) {
        FormValidation returnValue = FormValidation.ok();
        if (StringUtils.isBlank((String)testFile)) {
            returnValue = FormValidation.validateRequired((String)testFile);
        } else if (testFile.contains(PARAMETER)) {
            returnValue = FormValidation.warning((String)Messages.Builder_NoValidatedValue());
        } else if (!testFile.endsWith(".pkg")) {
            returnValue = FormValidation.error((String)Messages.TestBuilder_PkgFileExtension());
        }
        return returnValue;
    }

    public FormValidation validateProjectFile(String testFile) {
        FormValidation returnValue = FormValidation.ok();
        if (StringUtils.isBlank((String)testFile)) {
            returnValue = FormValidation.validateRequired((String)testFile);
        } else if (testFile.contains(PARAMETER)) {
            returnValue = FormValidation.warning((String)Messages.Builder_NoValidatedValue());
        } else if (!testFile.endsWith(".prj")) {
            returnValue = FormValidation.error((String)Messages.TestBuilder_PrjFileExtension());
        }
        return returnValue;
    }
}

