/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.util;

import de.tracetronic.jenkins.plugins.ecutest.ETPluginException;
import hudson.Launcher;
import hudson.model.Computer;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jvnet.winp.WinProcess;
import org.jvnet.winp.WinpException;

public final class ProcessUtil {
    private static final List<String> ET_PROCS = Arrays.asList("ECU-TEST.exe", "ECU-TEST_COM.exe", "ECU-TE~1.EXE");
    private static final List<String> TS_PROCS = Arrays.asList("Tool-Server.exe");

    private ProcessUtil() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static List<String> checkETProcesses(boolean kill) {
        return ProcessUtil.checkProcesses(ET_PROCS, kill);
    }

    public static List<String> checkTSProcess(boolean kill) {
        return ProcessUtil.checkProcesses(TS_PROCS, kill);
    }

    private static List<String> checkProcesses(List<String> processes, boolean kill) {
        ArrayList<String> found = new ArrayList<String>();
        WinProcess.enableDebugPrivilege();
        Iterator openProcesses = WinProcess.all().iterator();
        while (openProcesses.hasNext()) {
            try {
                WinProcess openProcess = (WinProcess)openProcesses.next();
                String cmdLine = openProcess.getCommandLine();
                for (String process : processes) {
                    if (!StringUtils.containsIgnoreCase((String)cmdLine, (String)process)) continue;
                    found.add(process);
                    if (!kill) continue;
                    ProcessUtil.killProcess(openProcess);
                }
            }
            catch (WinpException e) {
            }
        }
        return found;
    }

    private static void killProcess(WinProcess process) {
        process.killRecursively();
    }

    public static void checkOS(Launcher launcher) throws ETPluginException {
        if (launcher.isUnix()) {
            throw new ETPluginException("Trying to build Windows related configuration on an Unix-based system! Restrict the project to be built on a particular Windows slave or master.");
        }
    }

    public static boolean is64BitExecutable(String filePath) throws IOException {
        if (!filePath.endsWith(".exe")) {
            throw new IOException(String.format("%s is not a Windows .exe file.", filePath));
        }
        byte[] fileData = new byte[1024];
        try (FileInputStream input = new FileInputStream(filePath);){
            int bytesRead = input.read(fileData);
            for (int i = 0; i < bytesRead; ++i) {
                if (fileData[i] != 80 || i + 5 >= bytesRead || fileData[i + 1] != 69 || fileData[i + 2] != 0 || fileData[i + 3] != 0) continue;
                boolean bl = fileData[i + 4] == 100;
                return bl;
            }
        }
        return false;
    }

    public static boolean is64BitJVM(Computer computer) throws IOException, InterruptedException {
        if (computer == null) {
            throw new IOException("Could not access node properties!");
        }
        return "amd64".equals(computer.getSystemProperties().get("os.arch"));
    }
}

