/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.tool.installation;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.Util;
import hudson.model.EnvironmentSpecific;
import hudson.remoting.Callable;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import jenkins.security.MasterToSlaveCallable;

public abstract class AbstractToolInstallation
extends ToolInstallation
implements EnvironmentSpecific<AbstractToolInstallation>,
NodeSpecific<AbstractToolInstallation> {
    private static final long serialVersionUID = 1L;

    public AbstractToolInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(Util.fixEmptyAndTrim((String)name), Util.fixEmptyAndTrim((String)home), properties);
    }

    public AbstractToolInstallation(AbstractToolInstallation source, String home, List<? extends ToolProperty<?>> properties) {
        super(Util.fixEmptyAndTrim((String)source.getName()), Util.fixEmptyAndTrim((String)home), properties);
    }

    public String getExecutable(Launcher launcher) throws IOException, InterruptedException {
        return (String)launcher.getChannel().call((Callable)new MasterToSlaveCallable<String, IOException>(){
            private static final long serialVersionUID = 1L;

            public String call() throws IOException {
                File exe = AbstractToolInstallation.this.getExeFile();
                return exe != null && exe.exists() ? exe.getPath() : null;
            }
        });
    }

    @CheckForNull
    private File getExeFile() {
        if (this.getHome() != null) {
            String home = Util.replaceMacro((String)this.getHome(), (Map)EnvVars.masterEnvVars);
            return this.getExeFile(new File(home));
        }
        return null;
    }

    protected abstract File getExeFile(File var1);
}

