/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.tool.client;

import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.tool.client.AbstractToolClient;
import de.tracetronic.jenkins.plugins.ecutest.util.ProcessUtil;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.util.List;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang.StringUtils;

public class TSClient
extends AbstractToolClient {
    public static final int DEFAULT_TCP_PORT = 5017;
    private final String toolLibsIniPath;
    private final int tcpPort;

    public TSClient(String toolName, String installPath, int timeout, String toolLibsIniPath, int tcpPort) {
        super(toolName, installPath, timeout);
        this.toolLibsIniPath = StringUtils.trimToEmpty((String)toolLibsIniPath);
        this.tcpPort = tcpPort == 0 ? 5017 : tcpPort;
    }

    public TSClient(String toolName, int timeout) {
        super(toolName, timeout);
        this.toolLibsIniPath = "";
        this.tcpPort = 5017;
    }

    public String getToolLibsIniPath() {
        return this.toolLibsIniPath;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    @Override
    public boolean start(boolean checkProcesses, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        List<String> foundProcesses;
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        logger.logInfo("Starting Tool-Server...");
        if (checkProcesses && !(foundProcesses = TSClient.checkProcesses(launcher, true)).isEmpty()) {
            logger.logInfo(String.format("Terminated running processes: %s", foundProcesses));
        }
        if (StringUtils.isEmpty((String)this.getInstallPath())) {
            logger.logError("Tool-Server executable could not be found!");
        } else if (this.launchProcess(launcher, listener)) {
            logger.logInfo("Tool-Server started successfully.");
            return true;
        }
        return false;
    }

    @Override
    public boolean stop(boolean checkProcesses, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        logger.logInfo("Stopping Tool-Server...");
        if (((Boolean)launcher.getChannel().call((Callable)new StopCallable(this.getTimeout(), listener))).booleanValue()) {
            logger.logInfo("Tool-Server stopped successfully.");
            return true;
        }
        return false;
    }

    @Override
    public boolean restart(boolean checkProcesses, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return this.stop(checkProcesses, workspace, launcher, listener) && this.start(checkProcesses, workspace, launcher, listener);
    }

    @Override
    protected ArgumentListBuilder createCmdLine() {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(this.getInstallPath());
        args.add(new String[]{"--port", String.valueOf(this.getTcpPort())});
        if (!this.getToolLibsIniPath().isEmpty()) {
            args.add(new String[]{"--toollibsini", this.getToolLibsIniPath()});
        }
        return args;
    }

    public static List<String> checkProcesses(Launcher launcher, boolean kill) throws IOException, InterruptedException {
        return (List)launcher.getChannel().call((Callable)new CheckProcessCallable(kill));
    }

    private static final class CheckProcessCallable
    extends MasterToSlaveCallable<List<String>, IOException> {
        private static final long serialVersionUID = 1L;
        private final boolean kill;

        CheckProcessCallable(boolean kill) {
            this.kill = kill;
        }

        public List<String> call() throws IOException {
            return ProcessUtil.checkTSProcess(this.kill);
        }
    }

    private static final class StopCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final int timeout;
        private final TaskListener listener;

        StopCallable(int timeout, TaskListener listener) {
            this.timeout = timeout;
            this.listener = listener;
        }

        public Boolean call() throws IOException {
            boolean isTerminated = false;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            try {
                List<String> foundProcesses = ProcessUtil.checkTSProcess(false);
                if (foundProcesses.isEmpty()) {
                    logger.logWarn("No running Tool-Server instance found!");
                    isTerminated = true;
                } else {
                    long endTimeMillis = System.currentTimeMillis() + Long.valueOf(this.timeout) * 1000L;
                    while (this.timeout <= 0 || System.currentTimeMillis() < endTimeMillis) {
                        if (ProcessUtil.checkTSProcess(true).isEmpty()) {
                            isTerminated = true;
                            break;
                        }
                        Thread.sleep(1000L);
                    }
                    if (!isTerminated) {
                        logger.logError(String.format("-> Timeout of %d seconds reached!", this.timeout));
                    }
                }
            }
            catch (InterruptedException e) {
                logger.logError(e.getMessage());
            }
            return isTerminated;
        }
    }
}

