/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.tool.client;

import de.tracetronic.jenkins.plugins.ecutest.ETPlugin;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.tool.client.AbstractToolClient;
import de.tracetronic.jenkins.plugins.ecutest.util.DllUtil;
import de.tracetronic.jenkins.plugins.ecutest.util.ProcessUtil;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComClient;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComException;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComProperty;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.TestBenchConfiguration;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.TestConfiguration;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.util.List;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang.StringUtils;

public class ETClient
extends AbstractToolClient {
    private final String workspaceDir;
    private final String settingsDir;
    private final boolean debug;
    private String version;
    private String lastTbc;
    private String lastTcf;

    public ETClient(String toolName, String installPath, String workspaceDir, String settingsDir, int timeout, boolean debug) {
        super(toolName, installPath, timeout);
        this.workspaceDir = StringUtils.trimToEmpty((String)workspaceDir);
        this.settingsDir = StringUtils.trimToEmpty((String)settingsDir);
        this.debug = debug;
        this.version = "";
        this.lastTbc = "";
        this.lastTcf = "";
    }

    public ETClient(String toolName, int timeout) {
        super(toolName, timeout);
        this.workspaceDir = "";
        this.settingsDir = "";
        this.debug = false;
        this.version = "";
        this.lastTbc = "";
        this.lastTcf = "";
    }

    public String getWorkspaceDir() {
        return this.workspaceDir;
    }

    public String getSettingsDir() {
        return this.settingsDir;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String getVersion() {
        return this.version;
    }

    public String getLastTbc() {
        return this.lastTbc;
    }

    public String getLastTcf() {
        return this.lastTcf;
    }

    @Override
    public boolean start(boolean checkProcesses, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        List<String> foundProcesses;
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        logger.logInfo(String.format("Starting %s...", this.getToolName()));
        if (checkProcesses && !(foundProcesses = ETClient.checkProcesses(launcher, true)).isEmpty()) {
            logger.logInfo(String.format("Terminated running processes: %s", foundProcesses));
        }
        if (StringUtils.isEmpty((String)this.getInstallPath())) {
            logger.logError("ECU-TEST executable could not be found!");
            return false;
        }
        boolean is64BitJVM = ProcessUtil.is64BitJVM(workspace.toComputer());
        if (!this.checkProcessArchitecture(this.getInstallPath(), is64BitJVM, launcher)) {
            logger.logError("The configured ECU-TEST executable is not compatible with running Java VM! Please install a 64-bit JRE which supports 64-bit ECU-TEST installation!");
            return false;
        }
        if (!this.launchProcess(launcher, listener)) {
            return false;
        }
        if (!DllUtil.loadLibrary(workspace.toComputer())) {
            logger.logError("Could not load JACOB library!");
            return false;
        }
        String comVersion = (String)launcher.getChannel().call((Callable)new StartCallable(this.getTimeout(), listener));
        if (comVersion.isEmpty()) {
            logger.logError("Could not determine ECU-TEST version!");
            return false;
        }
        this.version = comVersion;
        logger.logDebug("COM ProgID: " + ETComProperty.getInstance().getProgId());
        logger.logDebug("COM version: " + comVersion);
        ETPlugin.ToolVersion comToolVersion = ETPlugin.ToolVersion.parse(comVersion);
        if (comToolVersion.compareWithoutMicroTo(ETPlugin.ET_MAX_VERSION) > 0) {
            logger.logWarn(String.format("The configured ECU-TEST version %s might be incompatible with this plugin. Currently supported versions: %s up to %s", comVersion, ETPlugin.ET_MIN_VERSION.toMinorString(), ETPlugin.ET_MAX_VERSION.toMinorString()));
        } else if (comToolVersion.compareTo(ETPlugin.ET_MIN_VERSION) < 0) {
            logger.logError(String.format("The configured ECU-TEST version %s is not compatible with this plugin. Please use at least ECU-TEST %s!", comVersion, ETPlugin.ET_MIN_VERSION.toMicroString()));
            this.stop(checkProcesses, workspace, launcher, listener);
            return false;
        }
        if (comToolVersion.compareWithoutMicroTo(new ETPlugin.ToolVersion(7, 0, 0, 0L)) >= 0) {
            this.lastTbc = (String)launcher.getChannel().call((Callable)new LastTbcCallable(listener));
            this.lastTcf = (String)launcher.getChannel().call((Callable)new LastTcfCallable(listener));
        }
        logger.logInfo(String.format("%s started successfully.", this.getToolName()));
        return true;
    }

    @Override
    public boolean stop(boolean checkProcesses, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        List<String> foundProcesses;
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        logger.logInfo(String.format("Stopping %s...", this.getToolName()));
        if (checkProcesses && (foundProcesses = ETClient.checkProcesses(launcher, false)).isEmpty()) {
            logger.logWarn("No running ECU-TEST instance found!");
            return true;
        }
        if (!DllUtil.loadLibrary(workspace.toComputer())) {
            logger.logError("Could not load JACOB library!");
            return false;
        }
        if (((Boolean)launcher.getChannel().call((Callable)new StopCallable(this.getTimeout(), checkProcesses, listener))).booleanValue()) {
            logger.logInfo(String.format("%s stopped successfully.", this.getToolName()));
            return true;
        }
        return false;
    }

    @Override
    public boolean restart(boolean checkProcesses, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return this.stop(checkProcesses, workspace, launcher, listener) && this.start(checkProcesses, workspace, launcher, listener);
    }

    @Override
    protected ArgumentListBuilder createCmdLine() {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(this.getInstallPath());
        if (!this.getWorkspaceDir().isEmpty()) {
            args.add(new String[]{"--workspaceDir", this.getWorkspaceDir()});
        }
        if (!this.getSettingsDir().isEmpty()) {
            args.add(new String[]{"-s", this.getSettingsDir()});
        }
        if (this.isDebug()) {
            args.add("-d");
        }
        args.add("--startupAutomated=CreateDirs");
        return args;
    }

    public static List<String> checkProcesses(Launcher launcher, boolean kill) throws IOException, InterruptedException {
        return (List)launcher.getChannel().call((Callable)new CheckProcessCallable(kill));
    }

    public static boolean stopProcesses(Launcher launcher, TaskListener listener, boolean kill) throws IOException, InterruptedException {
        return (Boolean)launcher.getChannel().call((Callable)new StopCallable(120, kill, listener));
    }

    public static String getComVersion(Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return (String)launcher.getChannel().call((Callable)new VersionCallable(listener));
    }

    public boolean checkProcessArchitecture(String processPath, boolean is64BitJVM, Launcher launcher) throws IOException, InterruptedException {
        return (Boolean)launcher.getChannel().call((Callable)new CheckProcessArchitectureCallable(processPath, is64BitJVM));
    }

    private static final class CheckProcessArchitectureCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final String processPath;
        private final boolean is64BitJVM;

        CheckProcessArchitectureCallable(String processPath, boolean is64BitJVM) {
            this.processPath = processPath;
            this.is64BitJVM = is64BitJVM;
        }

        public Boolean call() throws IOException {
            boolean is64BitProc = ProcessUtil.is64BitExecutable(this.processPath);
            return this.is64BitJVM || !is64BitProc;
        }
    }

    private static final class LastTcfCallable
    extends MasterToSlaveCallable<String, IOException> {
        private static final long serialVersionUID = 1L;
        private final TaskListener listener;

        LastTcfCallable(TaskListener listener) {
            this.listener = listener;
        }

        public String call() throws IOException {
            String tcfFilePath = "";
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);
                 TestConfiguration tcf = (TestConfiguration)comClient.getCurrentTestConfiguration();){
                tcfFilePath = StringUtils.trimToEmpty((String)tcf.getFileName());
            }
            catch (ETComException e) {
                logger.logError("-> Caught COM exception: " + e.getMessage());
            }
            return tcfFilePath;
        }
    }

    private static final class LastTbcCallable
    extends MasterToSlaveCallable<String, IOException> {
        private static final long serialVersionUID = 1L;
        private final TaskListener listener;

        LastTbcCallable(TaskListener listener) {
            this.listener = listener;
        }

        public String call() throws IOException {
            String tbcFilePath = "";
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);
                 TestBenchConfiguration tbc = (TestBenchConfiguration)comClient.getCurrentTestBenchConfiguration();){
                tbcFilePath = StringUtils.trimToEmpty((String)tbc.getFileName());
            }
            catch (ETComException e) {
                logger.logError("-> Caught COM exception: " + e.getMessage());
            }
            return tbcFilePath;
        }
    }

    private static final class VersionCallable
    extends MasterToSlaveCallable<String, IOException> {
        private static final long serialVersionUID = 1L;
        private final TaskListener listener;

        VersionCallable(TaskListener listener) {
            this.listener = listener;
        }

        public String call() throws IOException {
            String comVersion = "";
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                comVersion = comClient.getVersion();
            }
            catch (ETComException e) {
                logger.logError("-> Caught COM exception: " + e.getMessage());
            }
            return comVersion;
        }
    }

    private static final class CheckProcessCallable
    extends MasterToSlaveCallable<List<String>, IOException> {
        private static final long serialVersionUID = 1L;
        private final boolean kill;

        CheckProcessCallable(boolean kill) {
            this.kill = kill;
        }

        public List<String> call() throws IOException {
            return ProcessUtil.checkETProcesses(this.kill);
        }
    }

    private static final class StopCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final int timeout;
        private final boolean checkProcesses;
        private final TaskListener listener;

        StopCallable(int timeout, boolean checkProcesses, TaskListener listener) {
            this.timeout = timeout;
            this.checkProcesses = checkProcesses;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Boolean call() throws IOException {
            List<String> foundProcesses;
            boolean isTerminated = false;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId, this.timeout);){
                if (comClient.isApplicationRunning()) {
                    isTerminated = comClient.quit() || comClient.exit();
                } else {
                    logger.logError("ECU-TEST COM instance is not ready to use!");
                }
            }
            catch (ETComException e) {
                List<String> foundProcesses2;
                try {
                    logger.logComException(e.getMessage());
                }
                catch (Throwable throwable) {
                    List<String> foundProcesses3;
                    if (this.checkProcesses && !(foundProcesses3 = ProcessUtil.checkETProcesses(true)).isEmpty()) {
                        logger.logInfo(String.format("Terminated running processes: %s", foundProcesses3));
                    }
                    throw throwable;
                }
                if (this.checkProcesses && !(foundProcesses2 = ProcessUtil.checkETProcesses(true)).isEmpty()) {
                    logger.logInfo(String.format("Terminated running processes: %s", foundProcesses2));
                }
            }
            if (this.checkProcesses && !(foundProcesses = ProcessUtil.checkETProcesses(true)).isEmpty()) {
                logger.logInfo(String.format("Terminated running processes: %s", foundProcesses));
            }
            return isTerminated;
        }
    }

    private static final class StartCallable
    extends MasterToSlaveCallable<String, IOException> {
        private static final long serialVersionUID = 1L;
        private final int timeout;
        private final TaskListener listener;

        StartCallable(int timeout, TaskListener listener) {
            this.timeout = timeout;
            this.listener = listener;
        }

        public String call() throws IOException {
            String version = "";
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId, this.timeout);){
                if (comClient.isApplicationRunning()) {
                    version = comClient.getVersion();
                }
            }
            catch (ETComException e) {
                logger.logComException(e.getMessage());
            }
            return version;
        }
    }
}

