/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.tool;

import de.tracetronic.jenkins.plugins.ecutest.ETPluginException;
import de.tracetronic.jenkins.plugins.ecutest.tool.AbstractToolBuilder;
import de.tracetronic.jenkins.plugins.ecutest.tool.AbstractToolDescriptor;
import de.tracetronic.jenkins.plugins.ecutest.tool.Messages;
import de.tracetronic.jenkins.plugins.ecutest.tool.client.ETClient;
import de.tracetronic.jenkins.plugins.ecutest.tool.installation.ETInstallation;
import de.tracetronic.jenkins.plugins.ecutest.util.EnvUtil;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class StopETBuilder
extends AbstractToolBuilder {
    public static final int DEFAULT_TIMEOUT = 30;

    @DataBoundConstructor
    public StopETBuilder(@Nonnull String toolName) {
        super(toolName);
    }

    @Override
    public int getDefaultTimeout() {
        return 30;
    }

    @Override
    public void performTool(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException, ETPluginException {
        ETInstallation installation = this.configureToolInstallation(workspace.toComputer(), listener, run.getEnvironment(listener));
        String toolName = run.getEnvironment(listener).expand(installation.getName());
        EnvVars buildEnvVars = run.getEnvironment(listener);
        int expTimeout = Integer.parseInt(EnvUtil.expandEnvVar(this.getTimeout(), buildEnvVars, String.valueOf(30)));
        ETClient etClient = new ETClient(toolName, expTimeout);
        if (!etClient.stop(true, workspace, launcher, listener)) {
            throw new ETPluginException(String.format("Stopping %s failed.", toolName));
        }
    }

    @Symbol(value={"stopET"})
    @Extension(ordinal=10009.0)
    public static final class DescriptorImpl
    extends AbstractToolDescriptor {
        @Override
        public int getDefaultTimeout() {
            return 30;
        }

        public String getDisplayName() {
            return Messages.StopETBuilder_DisplayName();
        }
    }
}

