/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.tool;

import de.tracetronic.jenkins.plugins.ecutest.ETPluginException;
import de.tracetronic.jenkins.plugins.ecutest.env.ToolEnvInvisibleAction;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.tool.AbstractToolDescriptor;
import de.tracetronic.jenkins.plugins.ecutest.tool.installation.ETInstallation;
import de.tracetronic.jenkins.plugins.ecutest.util.ProcessUtil;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComProperty;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class AbstractToolBuilder
extends Builder
implements SimpleBuildStep {
    @Nonnull
    private final String toolName;
    @Nonnull
    private String timeout = String.valueOf(this.getDefaultTimeout());

    public AbstractToolBuilder(@Nonnull String toolName) {
        this.toolName = StringUtils.trimToEmpty((String)toolName);
    }

    @Nonnull
    public String getToolName() {
        return this.toolName;
    }

    @Nonnull
    public String getTimeout() {
        return this.timeout;
    }

    @DataBoundSetter
    public void setTimeout(@CheckForNull String timeout) {
        this.timeout = StringUtils.defaultIfBlank((String)timeout, (String)String.valueOf(this.getDefaultTimeout()));
    }

    public abstract int getDefaultTimeout();

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        try {
            ProcessUtil.checkOS(launcher);
            this.performTool(run, workspace, launcher, listener);
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            throw e;
        }
        catch (ETPluginException e) {
            TTConsoleLogger logger = new TTConsoleLogger(listener);
            logger.logError(e.getMessage());
            throw new AbortException(e.getMessage());
        }
    }

    protected abstract void performTool(Run<?, ?> var1, FilePath var2, Launcher var3, TaskListener var4) throws InterruptedException, IOException, ETPluginException;

    protected int getToolId(Run<?, ?> run) {
        List toolEnvActions = run.getActions(ToolEnvInvisibleAction.class);
        return toolEnvActions.size();
    }

    protected ETInstallation configureToolInstallation(Computer computer, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException, ETPluginException {
        ETInstallation installation = this.getToolInstallation(envVars);
        if (installation != null && computer != null) {
            Node node = computer.getNode();
            if (node != null) {
                installation = installation.forNode(node, listener);
                installation = installation.forEnvironment(envVars);
            }
        } else {
            throw new ETPluginException("The selected ECU-TEST installation is not configured for this node!");
        }
        ETComProperty.getInstance().setProgId(installation.getProgId());
        ETComProperty.getInstance().setTimeout(installation.getTimeout());
        return installation;
    }

    @CheckForNull
    public ETInstallation getToolInstallation(EnvVars envVars) {
        String expToolName = envVars.expand(this.getToolName());
        return this.getDescriptor().getToolDescriptor().getInstallation(expToolName);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public AbstractToolDescriptor getDescriptor() {
        return (AbstractToolDescriptor)super.getDescriptor();
    }
}

