/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.config;

import de.tracetronic.jenkins.plugins.ecutest.test.Messages;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExpandableConfig;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.TestValidator;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ProjectConfig
extends AbstractDescribableImpl<ProjectConfig>
implements Serializable,
ExpandableConfig {
    private static final long serialVersionUID = 1L;
    private final boolean execInCurrentPkgDir;
    private final String filterExpression;
    private final JobExecutionMode jobExecMode;

    @DataBoundConstructor
    public ProjectConfig(boolean execInCurrentPkgDir, String filterExpression, JobExecutionMode jobExecMode) {
        this.execInCurrentPkgDir = execInCurrentPkgDir;
        this.filterExpression = StringUtils.defaultIfBlank((String)filterExpression, (String)"");
        this.jobExecMode = jobExecMode;
    }

    public boolean isExecInCurrentPkgDir() {
        return this.execInCurrentPkgDir;
    }

    public String getFilterExpression() {
        return this.filterExpression;
    }

    public JobExecutionMode getJobExecMode() {
        return this.jobExecMode;
    }

    @Override
    public ProjectConfig expand(EnvVars envVars) {
        String expFilterExpression = envVars.expand(this.getFilterExpression());
        return new ProjectConfig(this.isExecInCurrentPkgDir(), expFilterExpression, this.getJobExecMode());
    }

    public final boolean equals(Object other) {
        boolean result = false;
        if (other instanceof ProjectConfig) {
            ProjectConfig that = (ProjectConfig)other;
            result = (this.filterExpression == null ? that.filterExpression == null : this.filterExpression.equals(that.filterExpression)) && this.execInCurrentPkgDir == that.execInCurrentPkgDir && this.jobExecMode == that.jobExecMode;
        }
        return result;
    }

    public final int hashCode() {
        return new HashCodeBuilder(17, 31).append(this.execInCurrentPkgDir).append((Object)this.filterExpression).append((Object)this.jobExecMode).toHashCode();
    }

    public static ProjectConfig newInstance() {
        return new ProjectConfig(false, null, JobExecutionMode.SEQUENTIAL_EXECUTION);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ProjectConfig> {
        private final TestValidator testValidator = new TestValidator();

        public String getDisplayName() {
            return "Project Configuration";
        }

        public JobExecutionMode getDefaultJobExecMode() {
            return JobExecutionMode.SEQUENTIAL_EXECUTION;
        }

        public ListBoxModel doFillJobExecModeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(Messages.TestProjectBuilder_JobExecutionMode_0(), JobExecutionMode.NO_EXECUTION.toString());
            items.add(Messages.TestProjectBuilder_JobExecutionMode_1(), JobExecutionMode.SEQUENTIAL_EXECUTION.toString());
            items.add(Messages.TestProjectBuilder_JobExecutionMode_2(), JobExecutionMode.PARALLEL_EXECUTION.toString());
            items.add(Messages.TestProjectBuilder_JobExecutionMode_5(), JobExecutionMode.SEPARATE_SEQUENTIAL_EXECUTION.toString());
            items.add(Messages.TestProjectBuilder_JobExecutionMode_6(), JobExecutionMode.SEPARATE_PARALLEL_EXECUTION.toString());
            items.add(Messages.TestProjectBuilder_JobExecutionMode_9(), JobExecutionMode.NO_TESTCASE_EXECUTION.toString());
            return items;
        }

        public FormValidation doCheckFilterExpression(@QueryParameter String value) {
            return this.testValidator.validateFilterExpression(value);
        }
    }

    public static enum JobExecutionMode {
        NO_EXECUTION(0),
        SEQUENTIAL_EXECUTION(1),
        PARALLEL_EXECUTION(2),
        SEPARATE_SEQUENTIAL_EXECUTION(5),
        SEPARATE_PARALLEL_EXECUTION(6),
        NO_TESTCASE_EXECUTION(9);

        private final int value;

        private JobExecutionMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static JobExecutionMode fromValue(Integer value) {
            JobExecutionMode execMode = SEQUENTIAL_EXECUTION;
            for (JobExecutionMode mode : JobExecutionMode.values()) {
                if (mode.getValue() != value.intValue()) continue;
                execMode = mode;
                break;
            }
            return execMode;
        }
    }
}

