/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.config;

import de.tracetronic.jenkins.plugins.ecutest.test.Messages;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExportConfig;
import de.tracetronic.jenkins.plugins.ecutest.util.EnvUtil;
import hudson.EnvVars;
import hudson.Extension;
import hudson.util.FormValidation;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ExportPackageConfig
extends ExportConfig {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public ExportPackageConfig(String filePath, String exportPath, boolean createNewPath, String credentialsId, String timeout) {
        super(filePath, exportPath, createNewPath, credentialsId, timeout);
    }

    @Override
    public ExportPackageConfig expand(EnvVars envVars) {
        String expFilePath = envVars.expand(this.getFilePath());
        String expExportPath = envVars.expand(this.getExportPath());
        String expCredentialsId = envVars.expand(this.getCredentialsId());
        String expTimeout = EnvUtil.expandEnvVar(this.getTimeout(), envVars, String.valueOf(60));
        return new ExportPackageConfig(expFilePath, expExportPath, this.isCreateNewPath(), expCredentialsId, expTimeout);
    }

    @Extension(ordinal=2.0)
    public static class DescriptorImpl
    extends ExportConfig.DescriptorImpl {
        @Override
        public FormValidation doCheckFilePath(@QueryParameter String value) {
            return this.tmsValidator.validatePackageFile(value);
        }

        public String getDisplayName() {
            return Messages.ExportPackageConfig_DisplayName();
        }
    }
}

