/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.client;

import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.test.client.TestClient;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExecutionConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.GlobalConstant;
import de.tracetronic.jenkins.plugins.ecutest.test.config.TestConfig;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComClient;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComException;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComProperty;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.TestConfiguration;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractTestClient
implements TestClient {
    private final String testFile;
    private final TestConfig testConfig;
    private final ExecutionConfig executionConfig;
    private String testName;
    private String testDescription;
    private String testReportDir;
    private String testResult;
    private boolean isAborted;

    public AbstractTestClient(String testFile, TestConfig testConfig, ExecutionConfig executionConfig) {
        this.testFile = StringUtils.trimToEmpty((String)testFile);
        this.testConfig = testConfig;
        this.executionConfig = executionConfig;
        this.testName = "";
        this.testDescription = "";
        this.testReportDir = "";
        this.testResult = "";
        this.isAborted = false;
    }

    public String getTestFile() {
        return this.testFile;
    }

    public TestConfig getTestConfig() {
        return this.testConfig;
    }

    public ExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }

    public String getTestName() {
        return this.testName;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    public String getTestDescription() {
        return this.testDescription;
    }

    public void setTestDescription(String testDescription) {
        this.testDescription = testDescription;
    }

    public String getTestReportDir() {
        return this.testReportDir;
    }

    public void setTestReportDir(String testReportDir) {
        this.testReportDir = testReportDir;
    }

    public String getTestResult() {
        return this.testResult;
    }

    public void setTestResult(String testResult) {
        this.testResult = testResult;
    }

    public boolean isAborted() {
        return this.isAborted;
    }

    public void setAborted(boolean isAborted) {
        this.isAborted = isAborted;
    }

    public static final class CheckInfoHolder {
        private final String filePath;
        private final Seriousness seriousness;
        private final String errorMessage;
        private final String lineNumber;

        public CheckInfoHolder(String filePath, Seriousness seriousness, String errorMessage, String lineNumber) {
            this.filePath = filePath;
            this.seriousness = seriousness;
            this.errorMessage = errorMessage;
            this.lineNumber = lineNumber;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public Seriousness getSeriousness() {
            return this.seriousness;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getLineNumber() {
            return this.lineNumber;
        }

        public static enum Seriousness {
            NOTE,
            WARNING,
            ERROR;

        }
    }

    protected static final class TestInfoHolder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String testResult;
        private final String testReportDir;
        private final boolean isAborted;

        public TestInfoHolder(String testResult, String testReportDir, boolean isAborted) {
            this.testResult = testResult;
            this.testReportDir = testReportDir;
            this.isAborted = isAborted;
        }

        public String getTestResult() {
            return this.testResult;
        }

        public String getTestReportDir() {
            return this.testReportDir;
        }

        public boolean isAborted() {
            return this.isAborted;
        }
    }

    protected static final class LoadConfigCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final TestConfig testConfig;
        private final TaskListener listener;

        public LoadConfigCallable(TestConfig testConfig, TaskListener listener) {
            this.testConfig = testConfig;
            this.listener = listener;
        }

        public Boolean call() throws IOException {
            String tbcFile = this.testConfig.getTbcFile();
            String tcfFile = this.testConfig.getTcfFile();
            List<GlobalConstant> constants = this.testConfig.getConstants();
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            boolean isLoaded = false;
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                String tbcName = this.getConfigName(tbcFile);
                String tcfName = this.getConfigName(tcfFile);
                logger.logInfo(String.format("- Loading configurations: TBC=%s TCF=%s", tbcName, tcfName));
                if (this.testConfig.isForceReload()) {
                    logger.logInfo("-> Forcing reload configurations...");
                    comClient.stop();
                }
                if (comClient.openTestConfiguration(StringUtils.defaultIfBlank((String)tcfFile, null))) {
                    if (tcfFile != null && !constants.isEmpty()) {
                        Map<String, String> constantMap = this.getGlobalConstantMap();
                        logger.logInfo("-> With global constants: " + constantMap.toString());
                        this.setGlobalConstants(comClient, constantMap);
                    }
                    logger.logInfo("-> Test configuration loaded successfully.");
                } else {
                    logger.logError(String.format("-> Loading TCF=%s failed!", tcfName));
                }
                if (comClient.openTestbenchConfiguration(StringUtils.defaultIfBlank((String)tbcFile, null))) {
                    logger.logInfo("-> Test bench configuration loaded successfully.");
                    isLoaded = true;
                } else {
                    logger.logError(String.format("-> Loading TBC=%s failed!", tbcName));
                }
                if (isLoaded) {
                    if (this.testConfig.isLoadOnly()) {
                        logger.logInfo("-> Starting configurations will be skipped.");
                    } else {
                        logger.logInfo("- Starting configurations...");
                        comClient.start();
                        logger.logInfo("-> Configurations started successfully.");
                    }
                }
            }
            catch (ETComException e) {
                logger.logComException(e.getMessage());
                isLoaded = false;
            }
            return isLoaded;
        }

        private String getConfigName(String configFile) {
            String configName = StringUtils.isBlank((String)configFile) ? "None" : new File(configFile).getName();
            return configName;
        }

        private void setGlobalConstants(ETComClient comClient, Map<String, String> constantMap) throws ETComException {
            comClient.start();
            TestConfiguration testConfig = (TestConfiguration)comClient.getCurrentTestConfiguration();
            for (Map.Entry<String, String> newConstant : constantMap.entrySet()) {
                testConfig.setGlobalConstant(newConstant.getKey(), newConstant.getValue());
            }
            comClient.stop();
        }

        private Map<String, String> getGlobalConstantMap() throws ETComException {
            LinkedHashMap<String, String> constantMap = new LinkedHashMap<String, String>();
            for (GlobalConstant constant : this.testConfig.getConstants()) {
                constantMap.put(constant.getName(), constant.getValue());
            }
            return constantMap;
        }
    }
}

