/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test;

import de.tracetronic.jenkins.plugins.ecutest.ETPluginException;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.test.AbstractTestHelper;
import de.tracetronic.jenkins.plugins.ecutest.test.client.AbstractTMSClient;
import de.tracetronic.jenkins.plugins.ecutest.test.client.ExportPackageClient;
import de.tracetronic.jenkins.plugins.ecutest.test.client.ExportProjectClient;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExportAttributeConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExportConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExportPackageAttributeConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExportPackageConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExportProjectAttributeConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExportProjectConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.TMSConfig;
import de.tracetronic.jenkins.plugins.ecutest.util.ProcessUtil;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class AbstractExportBuilder
extends AbstractTestHelper
implements SimpleBuildStep {
    @Nonnull
    private final List<TMSConfig> exportConfigs;

    @DataBoundConstructor
    public AbstractExportBuilder(@CheckForNull List<TMSConfig> exportConfigs) {
        this.exportConfigs = exportConfigs == null ? new ArrayList() : AbstractExportBuilder.removeEmptyConfigs(exportConfigs);
    }

    @Nonnull
    public List<TMSConfig> getExportConfigs() {
        return Collections.unmodifiableList(this.exportConfigs);
    }

    @DataBoundSetter
    public void setExportConfigs(@CheckForNull List<TMSConfig> exportConfigs) {
        this.exportConfigs.addAll(exportConfigs);
    }

    private static List<TMSConfig> removeEmptyConfigs(List<TMSConfig> exportConfigs) {
        ArrayList<TMSConfig> validConfigs = new ArrayList<TMSConfig>();
        for (TMSConfig config : exportConfigs) {
            ExportAttributeConfig pkgAttrConfig;
            if (config instanceof ExportConfig) {
                ExportConfig pkgConfig = (ExportConfig)config;
                if (!StringUtils.isNotBlank((String)pkgConfig.getFilePath()) || !StringUtils.isNotBlank((String)pkgConfig.getExportPath())) continue;
                validConfigs.add(config);
                continue;
            }
            if (!(config instanceof ExportAttributeConfig) || !StringUtils.isNotBlank((String)(pkgAttrConfig = (ExportAttributeConfig)config).getFilePath())) continue;
            validConfigs.add(config);
        }
        return validConfigs;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        try {
            ProcessUtil.checkOS(launcher);
            boolean performed = this.performExport(run, workspace, launcher, listener);
            if (!performed) {
                throw new AbortException("Exporting to test management system failed!");
            }
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            throw e;
        }
        catch (ETPluginException e) {
            logger.logError(e.getMessage());
            throw new AbortException(e.getMessage());
        }
    }

    private boolean performExport(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        if (!this.checkETInstance(launcher, false)) {
            logger.logError("No running ECU-TEST instance found, please configure one at first!");
            return false;
        }
        boolean isExported = false;
        for (TMSConfig exportConfig : this.exportConfigs) {
            AbstractTMSClient exportClient;
            EnvVars buildEnv = run.getEnvironment(listener);
            TMSConfig expExportConfig = (TMSConfig)exportConfig.expand(buildEnv);
            if (exportConfig instanceof ExportPackageConfig) {
                exportClient = new ExportPackageClient((ExportPackageConfig)expExportConfig);
                isExported = ((ExportPackageClient)exportClient).exportPackage((Item)run.getParent(), workspace, launcher, listener);
            } else if (exportConfig instanceof ExportPackageAttributeConfig) {
                exportClient = new ExportPackageClient((ExportPackageAttributeConfig)expExportConfig);
                isExported = ((ExportPackageClient)exportClient).exportPackageAttributes((Item)run.getParent(), workspace, launcher, listener);
            } else if (exportConfig instanceof ExportProjectConfig) {
                exportClient = new ExportProjectClient((ExportProjectConfig)expExportConfig);
                isExported = ((ExportProjectClient)exportClient).exportProject((Item)run.getParent(), workspace, launcher, listener);
            } else if (exportConfig instanceof ExportProjectAttributeConfig) {
                exportClient = new ExportProjectClient((ExportProjectAttributeConfig)expExportConfig);
                isExported = ((ExportProjectClient)exportClient).exportProjectAttributes((Item)run.getParent(), workspace, launcher, listener);
            } else {
                logger.logError("Unsupported export configuration of type: " + exportConfig.getClass());
            }
            if (isExported) continue;
            return false;
        }
        return true;
    }

    public static abstract class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl(Class<? extends AbstractExportBuilder> clazz) {
            super(clazz);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

