/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.tms;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import de.tracetronic.jenkins.plugins.ecutest.ETPlugin;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.test.client.AbstractTMSClient;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComClient;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComException;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComProperty;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.TestManagement;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.security.ACL;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import jenkins.security.MasterToSlaveCallable;
import org.acegisecurity.Authentication;

public class TMSReportUploader
extends AbstractTMSClient {
    private static final ETPlugin.ToolVersion ET_MIN_VERSION = new ETPlugin.ToolVersion(6, 5, 0, 0L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upload(List<FilePath> reportFiles, String credentialsId, String timeout, Item project, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        boolean isUploaded = false;
        if (this.isCompatible(ET_MIN_VERSION, workspace, launcher, listener)) {
            try {
                StandardUsernamePasswordCredentials credentials = this.getCredentials(credentialsId, project);
                if (this.login(credentials, launcher, listener)) {
                    isUploaded = (Boolean)launcher.getChannel().call((Callable)new UploadReportCallable(reportFiles, timeout, listener));
                }
            }
            finally {
                this.logout(launcher, listener);
            }
        }
        return isUploaded;
    }

    @CheckForNull
    private StandardUsernamePasswordCredentials getCredentials(String credentialsId, Item project) throws IOException, InterruptedException {
        List credentials = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, Collections.emptyList());
        return (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)credentials, (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    private static final class UploadReportCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final List<FilePath> reportFiles;
        private final String timeout;
        private final TaskListener listener;

        UploadReportCallable(List<FilePath> reportFiles, String timeout, TaskListener listener) {
            this.reportFiles = reportFiles;
            this.timeout = timeout;
            this.listener = listener;
        }

        public Boolean call() throws IOException {
            boolean isUploaded = true;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                TestManagement tm = (TestManagement)comClient.getTestManagement();
                for (FilePath reportFile : this.reportFiles) {
                    logger.logInfo(String.format("-> Publishing TRF report: %s", reportFile.getRemote()));
                    if (tm.exportReport(reportFile.getRemote(), Integer.parseInt(this.timeout))) continue;
                    isUploaded = false;
                    logger.logError("Publishing TRF report failed!");
                }
            }
            catch (ETComException e) {
                isUploaded = false;
                logger.logComException(e.getMessage());
            }
            return isUploaded;
        }
    }
}

