/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.tms;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import de.tracetronic.jenkins.plugins.ecutest.ETPluginException;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractReportDescriptor;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractReportPublisher;
import de.tracetronic.jenkins.plugins.ecutest.report.tms.Messages;
import de.tracetronic.jenkins.plugins.ecutest.report.tms.TMSReportUploader;
import de.tracetronic.jenkins.plugins.ecutest.tool.client.ETClient;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.TMSValidator;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class TMSPublisher
extends AbstractReportPublisher {
    private static final int DEFAULT_TIMEOUT = 60;
    @Nonnull
    private final String toolName;
    @Nonnull
    private final String credentialsId;
    private String timeout = String.valueOf(TMSPublisher.getDefaultTimeout());

    @DataBoundConstructor
    public TMSPublisher(@Nonnull String toolName, @Nonnull String credentialsId) {
        this.toolName = StringUtils.trimToEmpty((String)toolName);
        this.credentialsId = StringUtils.trimToEmpty((String)credentialsId);
    }

    @Nonnull
    public String getToolName() {
        return this.toolName;
    }

    @Nonnull
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setTimeout(@CheckForNull String timeout) {
        this.timeout = StringUtils.defaultIfBlank((String)timeout, (String)String.valueOf(TMSPublisher.getDefaultTimeout()));
    }

    @Nonnull
    public String getTimeout() {
        return this.timeout;
    }

    public static int getDefaultTimeout() {
        return 60;
    }

    @Override
    public void performReport(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException, ETPluginException {
        TTConsoleLogger logger = this.getLogger();
        logger.logInfo("Publishing reports to test management system...");
        if (this.isSkipped(true, run, launcher)) {
            return;
        }
        List<FilePath> reportFiles = this.getReportFiles(run, workspace, launcher);
        if (reportFiles.isEmpty() && !this.isAllowMissing()) {
            throw new ETPluginException("Empty test results are not allowed, setting build status to FAILURE!");
        }
        boolean isPublished = false;
        if (this.isETRunning(launcher)) {
            isPublished = this.publishReports(reportFiles, (Item)run.getParent(), workspace, launcher, listener);
        } else {
            ETClient etClient = this.getToolClient(this.toolName, run, workspace, launcher, listener);
            if (etClient.start(false, workspace, launcher, listener)) {
                isPublished = this.publishReports(reportFiles, (Item)run.getParent(), workspace, launcher, listener);
            } else {
                logger.logError(String.format("Starting %s failed.", this.toolName));
            }
            if (!etClient.stop(true, workspace, launcher, listener)) {
                logger.logError(String.format("Stopping %s failed.", this.toolName));
            }
        }
        if (isPublished) {
            logger.logInfo("Reports published successfully to test management system.");
        } else {
            logger.logInfo("Failed publishing report to test management system.");
            run.setResult(Result.FAILURE);
        }
    }

    private boolean publishReports(List<FilePath> reportFiles, Item project, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return new TMSReportUploader().upload(reportFiles, this.credentialsId, this.timeout, project, workspace, launcher, listener);
    }

    @Override
    protected String getUrlName() {
        throw new NotImplementedException();
    }

    @Symbol(value={"publishTMS"})
    @Extension(ordinal=10001.0)
    public static final class DescriptorImpl
    extends AbstractReportDescriptor {
        private final TMSValidator tmsValidator = new TMSValidator();

        public static int getDefaultTimeout() {
            return 60;
        }

        public FormValidation doCheckTimeout(@QueryParameter String value) {
            return this.tmsValidator.validateTimeout(value, DescriptorImpl.getDefaultTimeout());
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            return result.includeEmptyValue().includeMatchingAs(ACL.SYSTEM, item, StandardCredentials.class, Collections.emptyList(), CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class));
        }

        public String getDisplayName() {
            return Messages.TMSPublisher_DisplayName();
        }
    }
}

