/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.log;

import de.tracetronic.jenkins.plugins.ecutest.report.AbstractArchiveFileReport;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractTestReport;
import de.tracetronic.jenkins.plugins.ecutest.report.log.ETLogAnnotation;
import java.util.ArrayList;
import java.util.List;

public class ETLogReport
extends AbstractArchiveFileReport {
    private final List<ETLogAnnotation> logs;
    private final int warningLogCount;
    private final int errorLogCount;

    public ETLogReport(String id, String title, String fileName, long fileSize, List<ETLogAnnotation> logs, int warningLogCount, int errorLogCount) {
        super(id, title, fileName, fileSize);
        this.logs = logs == null ? new ArrayList() : logs;
        this.warningLogCount = warningLogCount;
        this.errorLogCount = errorLogCount;
    }

    public List<ETLogAnnotation> getLogs() {
        return this.logs;
    }

    public List<ETLogAnnotation> getWarningLogs() {
        return this.getLogs(ETLogAnnotation.Severity.WARNING);
    }

    public List<ETLogAnnotation> getErrorLogs() {
        return this.getLogs(ETLogAnnotation.Severity.ERROR);
    }

    private List<ETLogAnnotation> getLogs(ETLogAnnotation.Severity severity) {
        ArrayList<ETLogAnnotation> logs = new ArrayList<ETLogAnnotation>();
        for (ETLogAnnotation log : this.getLogs()) {
            if (!log.getSeverity().equals((Object)severity)) continue;
            logs.add(log);
        }
        return logs;
    }

    public int getWarningLogCount() {
        return this.warningLogCount;
    }

    public int getErrorLogCount() {
        return this.errorLogCount;
    }

    public int getTotalWarningCount() {
        int warningLogCount = this.getWarningLogCount();
        for (AbstractTestReport subReport : this.getSubReports()) {
            warningLogCount += ((ETLogReport)subReport).getTotalWarningCount();
        }
        return warningLogCount;
    }

    public int getTotalErrorCount() {
        int errorLogCount = this.getErrorLogCount();
        for (AbstractTestReport subReport : this.getSubReports()) {
            errorLogCount += ((ETLogReport)subReport).getTotalErrorCount();
        }
        return errorLogCount;
    }

    @Override
    public String getArchiveDir() {
        return "ecutest-logs";
    }
}

