/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.log;

import de.tracetronic.jenkins.plugins.ecutest.ETPluginException;
import de.tracetronic.jenkins.plugins.ecutest.env.ToolEnvInvisibleAction;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractReportDescriptor;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractReportPublisher;
import de.tracetronic.jenkins.plugins.ecutest.report.log.ETLogAnnotation;
import de.tracetronic.jenkins.plugins.ecutest.report.log.ETLogBuildAction;
import de.tracetronic.jenkins.plugins.ecutest.report.log.ETLogParser;
import de.tracetronic.jenkins.plugins.ecutest.report.log.ETLogReport;
import de.tracetronic.jenkins.plugins.ecutest.report.log.Messages;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.MasterToSlaveFileCallable;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ETLogPublisher
extends AbstractReportPublisher {
    public static final String INFO_LOG_NAME = "ECU_TEST_OUT.log";
    public static final String ERROR_LOG_NAME = "ECU_TEST_ERR.log";
    protected static final String URL_NAME = "ecutest-logs";
    private boolean unstableOnWarning;
    private boolean failedOnError;
    private boolean testSpecific;

    @DataBoundConstructor
    public ETLogPublisher() {
    }

    public boolean isUnstableOnWarning() {
        return this.unstableOnWarning;
    }

    public boolean isFailedOnError() {
        return this.failedOnError;
    }

    public boolean isTestSpecific() {
        return this.testSpecific;
    }

    @DataBoundSetter
    public void setUnstableOnWarning(boolean unstableOnWarning) {
        this.unstableOnWarning = unstableOnWarning;
    }

    @DataBoundSetter
    public void setFailedOnError(boolean failedOnError) {
        this.failedOnError = failedOnError;
    }

    @DataBoundSetter
    public void setTestSpecific(boolean testSpecific) {
        this.testSpecific = testSpecific;
    }

    @Override
    public void performReport(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException, ETPluginException {
        TTConsoleLogger logger = this.getLogger();
        logger.logInfo("Publishing ECU-TEST logs...");
        if (this.isSkipped(false, run, launcher)) {
            return;
        }
        if (this.isArchiving().booleanValue()) {
            ArrayList<ETLogReport> logReports = new ArrayList<ETLogReport>();
            FilePath archiveTarget = this.getArchiveTarget(run);
            if (!this.isKeepAll().booleanValue()) {
                archiveTarget.deleteRecursive();
                ETLogPublisher.removePreviousReports(run, ETLogBuildAction.class);
            }
            if (this.isTestSpecific()) {
                int index = 0;
                List<FilePath> reportDirs = this.getReportDirs(run, workspace, launcher);
                for (FilePath reportDir : reportDirs) {
                    FilePath archiveTargetDir = archiveTarget.child(reportDir.getName());
                    if (!reportDir.exists()) continue;
                    try {
                        logger.logInfo(String.format("- Archiving log files: %s", reportDir));
                        int copiedFiles = reportDir.copyRecursiveTo(String.format("**/%s,**/%s", ERROR_LOG_NAME, INFO_LOG_NAME), archiveTargetDir);
                        if (copiedFiles == 0) continue;
                        if (copiedFiles > 2) {
                            logger.logInfo(String.format("-> Archived %d sub-report(s).", copiedFiles / 2 - 1));
                        }
                    }
                    catch (IOException e) {
                        Util.displayIOException((IOException)e, (TaskListener)listener);
                        logger.logError("Failed publishing ECU-TEST logs.");
                        run.setResult(Result.FAILURE);
                        return;
                    }
                    index = this.traverseReports(logReports, archiveTargetDir, index);
                }
            } else {
                List<FilePath> logFiles = this.getCompleteLogFiles(run, workspace, launcher);
                for (FilePath logFile : logFiles) {
                    FilePath targetFile = archiveTarget.child(logFile.getName());
                    try {
                        if (!logFile.exists()) {
                            if (this.isAllowMissing()) continue;
                            logger.logError(String.format("Specified ECU-TEST log file '%s' does not exist.", logFile));
                            run.setResult(Result.FAILURE);
                            return;
                        }
                        logger.logInfo(String.format("- Archiving log file: %s", logFile));
                        logFile.copyTo(targetFile);
                    }
                    catch (IOException e) {
                        Util.displayIOException((IOException)e, (TaskListener)listener);
                        logger.logError("Failed publishing ECU-TEST logs.");
                        run.setResult(Result.FAILURE);
                        return;
                    }
                    ETLogReport logReport = this.parseLogFile(logFile, logFile.getParent(), logReports.size() + 1);
                    logReports.add(logReport);
                }
            }
            if (logReports.isEmpty()) {
                logger.logInfo("No log results found.");
                if (!this.isAllowMissing()) {
                    logger.logError("Empty log results are not allowed, setting build status to FAILURE!");
                    run.setResult(Result.FAILURE);
                    return;
                }
            } else {
                this.addBuildAction(run, logReports);
                this.setBuildResult(run, logReports);
            }
        } else {
            logger.logInfo("Archiving ECU-TEST logs is disabled.");
        }
        logger.logInfo("ECU-TEST logs published successfully.");
    }

    private ETLogReport parseLogFile(FilePath logFile, FilePath archiveTargetDir, int id) throws IOException, InterruptedException {
        ETLogParser logParser = new ETLogParser(logFile);
        List<ETLogAnnotation> logs = logParser.parse();
        int warningLogCount = logParser.parseLogCount(ETLogAnnotation.Severity.WARNING);
        int errorLogCount = logParser.parseLogCount(ETLogAnnotation.Severity.ERROR);
        String relLogFile = archiveTargetDir.toURI().relativize(logFile.toURI()).getPath();
        String logTitle = this.isTestSpecific() && !logFile.getParent().getParent().getName().equals(archiveTargetDir.getName()) ? logFile.getParent().getName().replaceFirst("^Report\\s", "") + "/" + logFile.getName() : logFile.getName();
        ETLogReport logReport = new ETLogReport(String.format("%d", id), logTitle, relLogFile, logFile.length(), logs, warningLogCount, errorLogCount);
        return logReport;
    }

    private int traverseReports(List<ETLogReport> logReports, FilePath archiveTargetDir, int id) throws IOException, InterruptedException {
        ETLogReport logReport = new ETLogReport(String.format("%d", ++id), archiveTargetDir.getName(), archiveTargetDir.getName(), this.getDirectorySize(archiveTargetDir), Collections.emptyList(), 0, 0);
        logReports.add(logReport);
        FilePath errorLogFile = archiveTargetDir.child(ERROR_LOG_NAME);
        FilePath infoLogFile = archiveTargetDir.child(INFO_LOG_NAME);
        if (errorLogFile.exists() && infoLogFile.exists()) {
            ETLogReport errorlogReport = this.parseLogFile(errorLogFile, archiveTargetDir.getParent(), ++id);
            logReport.addSubReport(errorlogReport);
            ETLogReport infoLogReport = this.parseLogFile(infoLogFile, archiveTargetDir.getParent(), ++id);
            logReport.addSubReport(infoLogReport);
        }
        id = this.traverseSubReports(logReport, archiveTargetDir.getParent(), archiveTargetDir, id);
        return id;
    }

    private int traverseSubReports(ETLogReport logReport, FilePath testReportDir, FilePath subTestReportDir, int id) throws IOException, InterruptedException {
        for (FilePath subDir : subTestReportDir.listDirectories()) {
            ETLogReport subReport;
            FilePath logFile = subDir.child(ERROR_LOG_NAME);
            if (logFile.exists()) {
                subReport = this.parseLogFile(logFile, testReportDir, ++id);
                logReport.addSubReport(subReport);
            }
            if (!(logFile = subDir.child(INFO_LOG_NAME)).exists()) continue;
            subReport = this.parseLogFile(logFile, testReportDir, ++id);
            logReport.addSubReport(subReport);
            id = this.traverseSubReports(subReport, testReportDir, subDir, id);
        }
        return id;
    }

    private void addBuildAction(Run<?, ?> run, List<ETLogReport> logReports) {
        ETLogBuildAction action = (ETLogBuildAction)run.getAction(ETLogBuildAction.class);
        if (action == null) {
            action = new ETLogBuildAction(this.isKeepAll() == false);
            run.addAction((Action)action);
        }
        action.addAll(logReports);
    }

    private void setBuildResult(Run<?, ?> run, List<ETLogReport> logReports) {
        TTConsoleLogger logger = this.getLogger();
        int totalWarnings = 0;
        int totalErrors = 0;
        for (ETLogReport logReport : logReports) {
            totalWarnings += logReport.getTotalWarningCount();
            totalErrors += logReport.getTotalErrorCount();
        }
        logger.logInfo("- Parsing log files...");
        if (totalErrors > 0 && this.isFailedOnError()) {
            logger.logInfo(String.format("-> %d error(s) found in the ECU-TEST logs, setting build status to FAILURE!", totalErrors));
            run.setResult(Result.FAILURE);
        } else if (totalWarnings > 0 && this.isUnstableOnWarning()) {
            logger.logInfo(String.format("-> %d warning(s) found in the ECU-TEST logs, setting build status to UNSTABLE!", totalWarnings));
            run.setResult(Result.UNSTABLE);
        } else {
            logger.logInfo(String.format("-> %d warning(s) and %d error(s) found in the ECU-TEST logs.", totalWarnings, totalErrors));
        }
    }

    private List<FilePath> getCompleteLogFiles(Run<?, ?> run, FilePath workspace, Launcher launcher) throws IOException, InterruptedException {
        ArrayList<FilePath> logFiles = new ArrayList<FilePath>();
        ToolEnvInvisibleAction toolEnvAction = (ToolEnvInvisibleAction)run.getAction(ToolEnvInvisibleAction.class);
        FilePath workspacePath = this.isDownstream() ? workspace.child(this.getWorkspace()) : (toolEnvAction != null ? new FilePath(launcher.getChannel(), toolEnvAction.getToolSettings()) : workspace);
        if (workspacePath != null && workspacePath.exists()) {
            String includes = String.format("%s,%s", INFO_LOG_NAME, ERROR_LOG_NAME);
            for (String includeFile : (List)workspacePath.act((FilePath.FileCallable)new ListFilesCallable(includes, ""))) {
                FilePath logFile = new FilePath(launcher.getChannel(), includeFile);
                logFiles.add(logFile);
            }
        }
        return logFiles;
    }

    @Override
    protected String getUrlName() {
        return URL_NAME;
    }

    public static final class RunListenerImpl {
        public static void onStarted(FilePath workspace, TaskListener listener) {
            if (workspace != null && listener != null) {
                try {
                    FilePath infoLogFile = workspace.child(ETLogPublisher.INFO_LOG_NAME);
                    FilePath errorLogFile = workspace.child(ETLogPublisher.ERROR_LOG_NAME);
                    if (infoLogFile.exists()) {
                        infoLogFile.delete();
                    }
                    if (errorLogFile.exists()) {
                        errorLogFile.delete();
                    }
                }
                catch (IOException | InterruptedException e) {
                    TTConsoleLogger logger = new TTConsoleLogger(listener);
                    logger.logWarn("Failed deleting ECU-TEST log files: " + e.getMessage());
                }
            }
        }
    }

    @Symbol(value={"publishETLogs"})
    @Extension(ordinal=10003.0)
    public static final class DescriptorImpl
    extends AbstractReportDescriptor {
        public String getDisplayName() {
            return Messages.ETLogPublisher_DisplayName();
        }
    }

    private static final class ListFilesCallable
    extends MasterToSlaveFileCallable<List<String>> {
        private static final long serialVersionUID = 1L;
        private final String includes;
        private final String excludes;

        ListFilesCallable(String includes, String excludes) {
            this.includes = includes;
            this.excludes = excludes;
        }

        public List<String> invoke(File baseDir, VirtualChannel channel) throws IOException, InterruptedException {
            ArrayList<String> files = new ArrayList<String>();
            for (String includedFile : Util.createFileSet((File)baseDir, (String)this.includes, (String)this.excludes).getDirectoryScanner().getIncludedFiles()) {
                File file = new File(baseDir, includedFile);
                files.add(file.getPath());
            }
            return files;
        }
    }
}

