/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.junit;

import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.junit.TestResult;
import hudson.tasks.test.TestResultParser;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import jenkins.MasterToSlaveFileCallable;

public class JUnitTestResultParser
extends TestResultParser
implements Serializable {
    private static final long serialVersionUID = 1L;

    public TestResult parseResult(List<FilePath> xmlFiles, TaskListener listener) throws IOException, InterruptedException {
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        TestResult testResult = new TestResult(false);
        for (FilePath xmlFile : xmlFiles) {
            if (!xmlFile.exists()) continue;
            logger.logInfo(String.format("- Processing UNIT test results: %s", xmlFile));
            testResult = (TestResult)xmlFile.act((FilePath.FileCallable)new ParseTestResultCallable(testResult));
            testResult.tally();
        }
        return testResult;
    }

    public String getDisplayName() {
        return "UNIT XML Parser";
    }

    public String getTestResultLocationMessage() {
        return "UNIT XML reports:";
    }

    private static final class ParseTestResultCallable
    extends MasterToSlaveFileCallable<TestResult> {
        private static final long serialVersionUID = 1L;
        private final TestResult testResult;

        ParseTestResultCallable(TestResult testResult) {
            this.testResult = testResult;
        }

        public TestResult invoke(File file, VirtualChannel channel) throws IOException, InterruptedException {
            this.testResult.parse(file, null);
            return this.testResult;
        }
    }
}

