/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.junit;

import de.tracetronic.jenkins.plugins.ecutest.ETPluginException;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractReportDescriptor;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractReportPublisher;
import de.tracetronic.jenkins.plugins.ecutest.report.junit.JUnitReportGenerator;
import de.tracetronic.jenkins.plugins.ecutest.report.junit.JUnitTestResultParser;
import de.tracetronic.jenkins.plugins.ecutest.report.junit.Messages;
import de.tracetronic.jenkins.plugins.ecutest.tool.installation.ETInstallation;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.JUnitValidator;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.TestResultAggregator;
import hudson.util.FormValidation;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class JUnitPublisher
extends AbstractReportPublisher
implements MatrixAggregatable {
    protected static final String JUNIT_REPORT_FILE = "junit-report.xml";
    protected static final String UNIT_TEMPLATE_NAME = "UNIT";
    @Nonnull
    private final String toolName;
    private double unstableThreshold;
    private double failedThreshold;

    @DataBoundConstructor
    public JUnitPublisher(@Nonnull String toolName) {
        this.toolName = StringUtils.trimToEmpty((String)toolName);
    }

    @Nonnull
    public String getToolName() {
        return this.toolName;
    }

    public double getUnstableThreshold() {
        return this.unstableThreshold;
    }

    public double getFailedThreshold() {
        return this.failedThreshold;
    }

    @DataBoundSetter
    public void setUnstableThreshold(double unstableThreshold) {
        this.unstableThreshold = JUnitPublisher.convertToPercentage(unstableThreshold);
    }

    @DataBoundSetter
    public void setFailedThreshold(double failedThreshold) {
        this.failedThreshold = JUnitPublisher.convertToPercentage(failedThreshold);
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new TestResultAggregator(build, launcher, listener);
    }

    @Override
    public void performReport(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException, ETPluginException {
        TTConsoleLogger logger = this.getLogger();
        logger.logInfo("Publishing UNIT reports...");
        if (this.isSkipped(true, run, launcher)) {
            return;
        }
        List<FilePath> reportFiles = this.getReportFiles(run, workspace, launcher);
        if (reportFiles.isEmpty() && !this.isAllowMissing()) {
            throw new ETPluginException("Empty test results are not allowed, setting build status to FAILURE!");
        }
        JUnitReportGenerator generator = new JUnitReportGenerator();
        ETInstallation installation = this.configureToolInstallation(this.toolName, workspace.toComputer(), listener, run.getEnvironment(listener));
        if (!generator.generate(installation, reportFiles, run, workspace, launcher, listener)) {
            run.setResult(Result.FAILURE);
            return;
        }
        String includes = String.format("**/%s/%s", UNIT_TEMPLATE_NAME, JUNIT_REPORT_FILE);
        List<FilePath> xmlFiles = this.getReportFiles(includes, "", run, workspace, launcher);
        JUnitTestResultParser parser = new JUnitTestResultParser();
        TestResult testResult = parser.parseResult(xmlFiles, listener);
        TestResultAction action = (TestResultAction)run.getAction(TestResultAction.class);
        if (action == null) {
            try {
                action = new TestResultAction(run, testResult, listener);
                run.addAction((Action)action);
            }
            catch (NullPointerException npe) {
                throw new ETPluginException(String.format("Parsing UNIT test results failed: %s", npe.getMessage()));
            }
        } else {
            action.setResult(testResult, listener);
        }
        testResult.freeze(action);
        if (this.setBuildResult(run, testResult)) {
            logger.logInfo("UNIT reports published successfully.");
        }
    }

    private boolean setBuildResult(Run<?, ?> run, TestResult testResult) {
        double failedPercentage;
        TTConsoleLogger logger = this.getLogger();
        if (testResult.getTotalCount() == 0) {
            logger.logInfo("-> No UNIT test results found.");
            if (!this.isAllowMissing()) {
                logger.logError("Empty test results are not allowed, setting build status to FAILURE!");
                run.setResult(Result.FAILURE);
                return false;
            }
        } else {
            logger.logInfo(String.format("-> Found %d test result(s) in total: #Passed: %d, #Failed: %d, #Skipped: %d", testResult.getTotalCount(), testResult.getPassCount(), testResult.getFailCount(), testResult.getSkipCount()));
        }
        if ((failedPercentage = JUnitPublisher.getFailedPercentage(testResult.getFailCount(), testResult.getTotalCount())) > this.failedThreshold) {
            logger.logInfo(String.format("-> %.1f%% of failed test results exceed failed threshold of %.1f%%, setting build status to FAILURE!", failedPercentage, this.failedThreshold));
            run.setResult(Result.FAILURE);
        } else if (failedPercentage > this.unstableThreshold) {
            logger.logInfo(String.format("-> %.1f%% of failed test results exceed unstable threshold of %.1f%%, setting build status to UNSTABLE!", failedPercentage, this.unstableThreshold));
            run.setResult(Result.UNSTABLE);
        }
        return true;
    }

    static double getFailedPercentage(int failedCount, int totalCount) {
        if (totalCount == 0) {
            return 0.0;
        }
        double percentage = (double)failedCount / (double)totalCount * 100.0;
        return JUnitPublisher.roundToDecimals(percentage, 1);
    }

    private static double roundToDecimals(double value, int decimals) {
        BigDecimal bd = new BigDecimal(Double.toString(value));
        bd = bd.setScale(decimals, 4);
        return bd.doubleValue();
    }

    private static double convertToPercentage(double value) {
        if (value < 0.0) {
            return 0.0;
        }
        if (value > 100.0) {
            return 100.0;
        }
        return value;
    }

    @Override
    protected String getUrlName() {
        throw new NotImplementedException();
    }

    @Symbol(value={"publishUNIT"})
    @Extension(ordinal=10005.0, optional=true)
    public static final class DescriptorImpl
    extends AbstractReportDescriptor {
        private final JUnitValidator unitValidator = new JUnitValidator();

        public String getDisplayName() {
            return Messages.JUnitPublisher_DisplayName();
        }

        public FormValidation doCheckUnstableThreshold(@QueryParameter String value) {
            return this.unitValidator.validateUnstableThreshold(value);
        }

        public FormValidation doCheckFailedThreshold(@QueryParameter String value) {
            return this.unitValidator.validateFailedThreshold(value);
        }
    }
}

