/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.generator;

import de.tracetronic.jenkins.plugins.ecutest.report.generator.ReportGeneratorSetting;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExpandableConfig;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.ReportGeneratorValidator;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ReportGeneratorConfig
extends AbstractDescribableImpl<ReportGeneratorConfig>
implements ExpandableConfig,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<ReportGeneratorSetting> settings;

    @DataBoundConstructor
    public ReportGeneratorConfig(String name, List<ReportGeneratorSetting> settings) {
        this.name = StringUtils.trimToEmpty((String)name);
        this.settings = settings == null ? new ArrayList() : ReportGeneratorConfig.removeEmptySettings(settings);
    }

    public String getName() {
        return this.name;
    }

    public List<ReportGeneratorSetting> getSettings() {
        return this.settings;
    }

    private static List<ReportGeneratorSetting> removeEmptySettings(List<ReportGeneratorSetting> settings) {
        ArrayList<ReportGeneratorSetting> validSettings = new ArrayList<ReportGeneratorSetting>();
        for (ReportGeneratorSetting setting : settings) {
            if (!StringUtils.isNotBlank((String)setting.getName())) continue;
            validSettings.add(setting);
        }
        return validSettings;
    }

    @Override
    public ReportGeneratorConfig expand(EnvVars envVars) {
        String expName = envVars.expand(this.getName());
        ArrayList<ReportGeneratorSetting> settings = new ArrayList<ReportGeneratorSetting>();
        for (ReportGeneratorSetting setting : this.getSettings()) {
            settings.add(setting.expand(envVars));
        }
        return new ReportGeneratorConfig(expName, settings);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ReportGeneratorConfig> {
        private static final List<String> REPORT_GENERATORS = Arrays.asList("ATX", "EXCEL", "HTML", "JSON", "OMR", "TestSpec", "TRF-SPLIT", "TXT", "UNIT");
        private final ReportGeneratorValidator reportValidator = new ReportGeneratorValidator();

        public ListBoxModel doFillNameItems() {
            ListBoxModel model = new ListBoxModel();
            for (String generator : REPORT_GENERATORS) {
                model.add(generator, generator);
            }
            return model;
        }

        public FormValidation doCheckName(@QueryParameter String value) {
            return this.reportValidator.validateGeneratorName(value);
        }

        public String getDisplayName() {
            return "Report Generator Configuration";
        }
    }
}

