/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.generator;

import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.report.generator.ReportGeneratorConfig;
import de.tracetronic.jenkins.plugins.ecutest.report.generator.ReportGeneratorSetting;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComClient;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComException;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComProperty;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.TestEnvironment;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jenkins.security.MasterToSlaveCallable;

public class ReportGenerator {
    private final ReportGeneratorConfig config;

    public ReportGenerator(ReportGeneratorConfig config) {
        this.config = config;
    }

    public ReportGeneratorConfig getConfig() {
        return this.config;
    }

    public boolean generate(List<FilePath> reportFiles, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return (Boolean)launcher.getChannel().call((Callable)new GenerateReportCallable(this.config, reportFiles, listener));
    }

    private static final class GenerateReportCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final ReportGeneratorConfig config;
        private final List<FilePath> dbFiles;
        private final TaskListener listener;

        GenerateReportCallable(ReportGeneratorConfig config, List<FilePath> dbFiles, TaskListener listener) {
            this.config = config;
            this.dbFiles = dbFiles;
            this.listener = listener;
        }

        public Boolean call() throws IOException {
            boolean isGenerated = true;
            String templateName = this.config.getName();
            Map<String, String> configMap = this.getConfigMap();
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                TestEnvironment testEnv = (TestEnvironment)comClient.getTestEnvironment();
                logger.logInfo(String.format("- Generating %s test reports...", templateName));
                for (FilePath dbFile : this.dbFiles) {
                    logger.logInfo(String.format("-> Generating %s report: %s", templateName, dbFile.getRemote()));
                    FilePath outDir = dbFile.getParent().child(templateName);
                    if (testEnv.generateTestReportDocumentFromDB(dbFile.getRemote(), outDir.getRemote(), templateName, true, configMap)) continue;
                    isGenerated = false;
                    logger.logError(String.format("Generating %s report failed!", templateName));
                }
            }
            catch (ETComException e) {
                isGenerated = false;
                logger.logComException(e.getMessage());
            }
            return isGenerated;
        }

        private Map<String, String> getConfigMap() {
            LinkedHashMap<String, String> configMap = new LinkedHashMap<String, String>();
            for (ReportGeneratorSetting setting : this.config.getSettings()) {
                configMap.put(setting.getName(), setting.getValue());
            }
            return configMap;
        }
    }
}

