/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.atx.installation;

import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXBooleanSetting;
import java.io.Serializable;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.localizer.LocaleProvider;

public abstract class ATXSetting<T>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ATXSetting.class.getName());
    private final String name;
    private final String descGerman;
    private final String descEnglish;
    private final T defaultValue;
    protected T currentValue;

    public ATXSetting(String name, String descGerman, String descEnglish, T defaultValue) {
        this.name = name;
        this.descGerman = descGerman;
        this.descEnglish = descEnglish;
        this.defaultValue = defaultValue;
        this.currentValue = defaultValue;
    }

    public ATXSetting<T> clone() {
        ATXSetting clone = null;
        try {
            clone = (ATXSetting)super.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.log(Level.SEVERE, "Could not clone ATXSetting!", e);
        }
        return clone;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return ATXSetting.toSpaceCase(this.name);
    }

    public String getDescGerman() {
        return this.descGerman;
    }

    public String getDescEnglish() {
        return this.descEnglish;
    }

    public String getDescription() {
        String locale = LocaleProvider.getLocale().getLanguage();
        String description = locale.equals(new Locale("de").getLanguage()) ? this.getDescGerman() : this.getDescEnglish();
        return description;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(T currentValue) {
        this.currentValue = currentValue;
    }

    public boolean isCheckbox() {
        return this instanceof ATXBooleanSetting;
    }

    public static String toString(boolean value) {
        return value ? "True" : "False";
    }

    private static String toSpaceCase(String camelCase) {
        String separated = camelCase.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " ");
        return Character.toString(separated.charAt(0)).toUpperCase(Locale.getDefault()) + separated.substring(1);
    }
}

