/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.atx.installation;

import de.tracetronic.jenkins.plugins.ecutest.report.atx.ATXPublisher;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXCustomSetting;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXSetting;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXSettingParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ATXConfig
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ATXPublisher.class.getName());
    private final Map<String, List<ATXSetting>> configMap;
    private List<ATXCustomSetting> customSettings;

    public ATXConfig() {
        this.configMap = this.parseDefaultConfig();
        this.customSettings = new ArrayList<ATXCustomSetting>();
    }

    public ATXConfig(Map<String, List<ATXSetting>> configMap, List<ATXCustomSetting> customSettings) {
        this.configMap = configMap == null ? new LinkedHashMap() : configMap;
        this.customSettings = customSettings == null ? new ArrayList() : customSettings;
    }

    public ATXConfig clone() {
        ATXConfig clone = null;
        try {
            ATXConfig configClone = (ATXConfig)super.clone();
            LinkedHashMap<String, List<ATXSetting>> configMap = new LinkedHashMap<String, List<ATXSetting>>();
            for (Map.Entry<String, List<ATXSetting>> config : configClone.getConfigMap().entrySet()) {
                ArrayList<Object> settings = new ArrayList<Object>();
                for (ATXSetting setting : config.getValue()) {
                    settings.add(setting.clone());
                }
                configMap.put(config.getKey(), settings);
            }
            ArrayList<ATXCustomSetting> customSettings = new ArrayList<ATXCustomSetting>();
            for (ATXCustomSetting setting : configClone.getCustomSettings()) {
                customSettings.add(setting.clone());
            }
            clone = new ATXConfig(configMap, customSettings);
        }
        catch (CloneNotSupportedException e) {
            LOGGER.log(Level.SEVERE, "Could not clone ATXConfig!", e);
        }
        return clone;
    }

    private Map<String, List<ATXSetting>> parseDefaultConfig() {
        Document doc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try (InputStream configFile = ATXConfig.class.getResourceAsStream("config.xml");){
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(configFile);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOGGER.log(Level.SEVERE, "Error parsing ATX template configuration: " + e.getMessage(), e);
        }
        return ATXSettingParser.parseSettings(doc);
    }

    public Map<String, List<ATXSetting>> getConfigMap() {
        return this.configMap;
    }

    public List<ATXSetting> getConfigByName(String configName) {
        return this.configMap.get(configName);
    }

    @CheckForNull
    public ATXSetting getSettingByName(String settingName) {
        ATXSetting settingByName = null;
        boolean found = false;
        for (Map.Entry<String, List<ATXSetting>> config : this.configMap.entrySet()) {
            for (ATXSetting setting : config.getValue()) {
                if (!setting.getName().equals(settingName)) continue;
                settingByName = setting;
                found = true;
                break;
            }
            if (!found) continue;
            break;
        }
        return settingByName;
    }

    @CheckForNull
    public Object getSettingValueByName(String settingName, List<ATXSetting> settings) {
        ATXSetting settingByName = null;
        if (settings != null) {
            for (ATXSetting setting : settings) {
                if (!setting.getName().equals(settingName)) continue;
                settingByName = setting;
                break;
            }
        }
        return settingByName == null ? null : settingByName.getCurrentValue();
    }

    public List<ATXCustomSetting> getCustomSettings() {
        return this.customSettings;
    }

    public void setCustomSettings(List<ATXCustomSetting> customSettings) {
        this.customSettings = customSettings;
    }
}

