/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.atx;

import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXBooleanSetting;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXConfig;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXCustomBooleanSetting;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXCustomSetting;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXCustomTextSetting;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXInstallation;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXSetting;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXTextSetting;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jenkins.security.MasterToSlaveCallable;

public abstract class AbstractATXReportHandler {
    protected static final String ATX_TEMPLATE_NAME = "ATX";
    private final ATXInstallation installation;

    public AbstractATXReportHandler(ATXInstallation installation) {
        this.installation = installation;
    }

    protected ATXInstallation getInstallation() {
        return this.installation;
    }

    protected static abstract class AbstractReportCallable<T>
    extends MasterToSlaveCallable<T, IOException> {
        private static final long serialVersionUID = 1L;
        private final ATXConfig config;
        private final List<FilePath> reportFiles;
        private final EnvVars envVars;
        private final TaskListener listener;

        public AbstractReportCallable(ATXConfig config, List<FilePath> reportFiles, EnvVars envVars, TaskListener listener) {
            this.config = config;
            this.reportFiles = reportFiles;
            this.envVars = envVars;
            this.listener = listener;
        }

        public List<FilePath> getReportFiles() {
            return this.reportFiles;
        }

        public TaskListener getListener() {
            return this.listener;
        }

        protected Map<String, String> getConfigMap(boolean uploadToServer) {
            LinkedHashMap<String, String> configMap = new LinkedHashMap<String, String>();
            for (List<ATXSetting> settings : this.config.getConfigMap().values()) {
                for (ATXSetting setting : settings) {
                    if (setting instanceof ATXBooleanSetting) {
                        if ("uploadToServer".equals(setting.getName())) {
                            configMap.put(setting.getName(), ATXSetting.toString(uploadToServer));
                            continue;
                        }
                        configMap.put(setting.getName(), ATXSetting.toString((Boolean)((ATXBooleanSetting)setting).getCurrentValue()));
                        continue;
                    }
                    configMap.put(setting.getName(), this.envVars.expand((String)((ATXTextSetting)setting).getCurrentValue()));
                }
            }
            for (ATXCustomSetting setting : this.config.getCustomSettings()) {
                if (setting instanceof ATXCustomBooleanSetting) {
                    configMap.put(setting.getName(), ATXSetting.toString(((ATXCustomBooleanSetting)setting).isChecked()));
                    continue;
                }
                if (!(setting instanceof ATXCustomTextSetting)) continue;
                configMap.put(setting.getName(), this.envVars.expand(((ATXCustomTextSetting)setting).getValue()));
            }
            return configMap;
        }
    }
}

