/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.atx;

import de.tracetronic.jenkins.plugins.ecutest.env.TestEnvInvisibleAction;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractReportPublisher;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.ATXBuildAction;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.ATXReport;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.AbstractATXReportHandler;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXConfig;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXInstallation;
import de.tracetronic.jenkins.plugins.ecutest.util.ATXUtil;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.ATXValidator;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComClient;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComException;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComProperty;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.TestEnvironment;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.groovy.JsonSlurper;

public class ATXReportUploader
extends AbstractATXReportHandler {
    private static final String ATX_TREND_URL = "wicket/bookmarkable/de.tracetronic.ttstm.web.detail.TestReportViewPage?testCase";

    public ATXReportUploader(ATXInstallation installation) {
        super(installation);
    }

    public boolean upload(List<FilePath> reportDirs, boolean allowMissing, Run<?, ?> run, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        ArrayList<ATXReport> atxReports = new ArrayList<ATXReport>();
        EnvVars envVars = run.getEnvironment(listener);
        ATXConfig config = this.getInstallation().getConfig();
        String projectId = ATXUtil.getProjectId(config, envVars);
        String baseUrl = ATXUtil.getBaseUrl(config, envVars);
        if (baseUrl == null) {
            logger.logError(String.format("Error getting base URL for selected TEST-GUIDE installation: %s", this.getInstallation().getName()));
            return false;
        }
        int index = 0;
        for (FilePath reportDir : reportDirs) {
            FilePath reportFile = AbstractReportPublisher.getFirstReportFile(reportDir);
            if (reportFile != null && reportFile.exists()) {
                List<FilePath> uploadFiles = Arrays.asList(reportDir.list("**/*.trf", "*/**/Job_*.trf"));
                TestInfoHolder testInfo = (TestInfoHolder)launcher.getChannel().call((Callable)new UploadReportCallable(config, uploadFiles, envVars, listener));
                String title = reportFile.getParent().getName();
                if (testInfo == null) {
                    testInfo = (TestInfoHolder)launcher.getChannel().call((Callable)new ParseTRFCallable(reportFile.getRemote()));
                }
                String testName = testInfo.getTestName();
                TestEnvInvisibleAction.TestType testType = testInfo.getTestType();
                String from = String.valueOf(testInfo.getFrom());
                String to = String.valueOf(testInfo.getTo());
                index = this.traverseReports(atxReports, reportDir, index, title, baseUrl, from, to, testName, testType, projectId);
                continue;
            }
            if (allowMissing) continue;
            logger.logError(String.format("Specified TRF file '%s' does not exist.", reportFile));
            return false;
        }
        if (atxReports.isEmpty() && !allowMissing) {
            logger.logError("Empty test results are not allowed, setting build status to FAILURE!");
            return false;
        }
        this.addBuildAction(run, atxReports);
        return true;
    }

    private int traverseReports(List<ATXReport> atxReports, FilePath testReportDir, int id, String title, String baseUrl, String from, String to, String testName, TestEnvInvisibleAction.TestType testType, String projectId) throws IOException, InterruptedException {
        String reportUrl = null;
        String trendReportUrl = null;
        String atxTestName = ATXUtil.getValidATXName(testName);
        if (testType == TestEnvInvisibleAction.TestType.PACKAGE) {
            reportUrl = this.getPkgReportUrl(baseUrl, from, to, atxTestName, projectId);
            trendReportUrl = this.getPkgTrendReportUrl(baseUrl, atxTestName, projectId);
        } else {
            reportUrl = this.getPrjReportUrl(baseUrl, from, to, atxTestName, null, projectId);
        }
        ATXReport atxReport = new ATXReport(String.format("%d", ++id), title, reportUrl);
        if (trendReportUrl != null) {
            atxReport.addSubReport(new ATXReport(String.format("%d", ++id), title, trendReportUrl, true));
        }
        atxReports.add(atxReport);
        boolean isSingleTestplanMap = ATXUtil.isSingleTestplanMap(this.getInstallation().getConfig());
        id = isSingleTestplanMap ? this.traverseSubReports(atxReport, testReportDir, id, baseUrl, from, to, null, projectId) : this.traverseSubReports(atxReport, testReportDir, id, baseUrl, from, to, atxTestName, projectId);
        return id;
    }

    private int traverseSubReports(ATXReport atxReport, FilePath testReportDir, int id, String baseUrl, String from, String to, String projectName, String projectId) throws IOException, InterruptedException {
        for (FilePath subDir : testReportDir.listDirectories()) {
            FilePath reportFile = AbstractReportPublisher.getFirstReportFile(subDir);
            if (reportFile == null || !reportFile.exists()) continue;
            String testName = reportFile.getParent().getName().replaceFirst("^Report\\s", "");
            String atxTestName = ATXUtil.getValidATXName(testName);
            String reportUrl = this.getPrjReportUrl(baseUrl, from, to, atxTestName, projectName, projectId);
            ATXReport subReport = new ATXReport(String.format("%d", ++id), testName, reportUrl);
            atxReport.addSubReport(subReport);
            id = this.traverseSubReports(subReport, subDir, id, baseUrl, from, to, projectName, projectId);
        }
        return id;
    }

    private void addBuildAction(Run<?, ?> run, List<ATXReport> atxReports) {
        ATXBuildAction<ATXReport> action = (ATXBuildAction<ATXReport>)run.getAction(ATXBuildAction.class);
        if (action == null) {
            action = new ATXBuildAction<ATXReport>(false);
            run.addAction(action);
        }
        action.addAll(atxReports);
    }

    private String getPkgTrendReportUrl(String baseUrl, String testName, String projectId) {
        String pkgTrendReportUrl = String.format("%s/%s=%s", baseUrl, ATX_TREND_URL, testName);
        if (projectId != null) {
            pkgTrendReportUrl = String.format("%s&projectId=%s", pkgTrendReportUrl, projectId);
        }
        return pkgTrendReportUrl;
    }

    private String getPkgReportUrl(String baseUrl, String from, String to, String testName, String projectId) {
        String pkgReportUrl = String.format("%s/reports?dateFrom=%s&dateTo=%s&testcase=%s", baseUrl, from, to, testName);
        if (projectId != null) {
            pkgReportUrl = String.format("%s&projectId=%s", pkgReportUrl, projectId);
        }
        return pkgReportUrl;
    }

    private String getPrjReportUrl(String baseUrl, String from, String to, String testName, String projectName, String projectId) {
        String prjReportUrl = projectName != null ? String.format("%s/reports?dateFrom=%s&dateTo=%s&testexecplan=%s&plannedTestCaseFolder=%s*", baseUrl, from, to, projectName, testName) : String.format("%s/reports?dateFrom=%s&dateTo=%s&testexecplan=%s", baseUrl, from, to, testName);
        if (projectId != null) {
            prjReportUrl = String.format("%s&projectId=%s", prjReportUrl, projectId);
        }
        return prjReportUrl;
    }

    private static final class TestInfoHolder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String testName;
        private final TestEnvInvisibleAction.TestType testType;
        private final long from;
        private final long to;

        TestInfoHolder(String testName, TestEnvInvisibleAction.TestType testType, long from, long to) {
            this.testName = testName;
            this.testType = testType;
            this.from = from;
            this.to = to;
        }

        public String getTestName() {
            return this.testName;
        }

        public TestEnvInvisibleAction.TestType getTestType() {
            return this.testType;
        }

        public long getFrom() {
            return this.from;
        }

        public long getTo() {
            return this.to;
        }
    }

    private static final class ParseTRFCallable
    extends MasterToSlaveCallable<TestInfoHolder, IOException> {
        private static final long serialVersionUID = 1L;
        private final String trfFile;

        ParseTRFCallable(String trfFile) {
            this.trfFile = trfFile;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public TestInfoHolder call() throws IOException {
            try (SQLite sql = new SQLite(this.trfFile);){
                ResultSet rs = sql.query("SELECT execution_time, duration from info");
                String execTime = rs.getString("execution_time");
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = fmt.parse(execTime);
                float duration = rs.getFloat("duration") * 1000.0f;
                long from = date.getTime();
                long to = from + (long)duration;
                rs = sql.query("SELECT name FROM prj");
                String prjName = rs.getString("name");
                if ("$$$_PACKAGE_$$$".equals(prjName)) {
                    rs = sql.query("SELECT name FROM pkg");
                    String pkgName = rs.getString("name");
                    TestInfoHolder testInfoHolder = new TestInfoHolder(pkgName, TestEnvInvisibleAction.TestType.PACKAGE, from, to);
                    return testInfoHolder;
                }
                TestInfoHolder testInfoHolder = new TestInfoHolder(prjName, TestEnvInvisibleAction.TestType.PROJECT, from, to);
                return testInfoHolder;
            }
            catch (ClassNotFoundException | SQLException | ParseException e) {
                throw new IOException(e);
            }
        }

        private static class SQLite
        implements AutoCloseable {
            private final Connection connection;
            private final Statement statement;

            SQLite(String sqlFile) throws ClassNotFoundException, SQLException {
                Class.forName("org.sqlite.JDBC");
                this.connection = DriverManager.getConnection("jdbc:sqlite:" + sqlFile);
                this.statement = this.connection.createStatement();
            }

            public ResultSet query(String sql) throws SQLException {
                return this.statement.executeQuery(sql);
            }

            @Override
            public void close() throws SQLException {
                if (this.statement != null) {
                    this.statement.close();
                }
                if (this.connection != null) {
                    this.connection.close();
                }
            }
        }
    }

    private static final class UploadReportCallable
    extends AbstractATXReportHandler.AbstractReportCallable<TestInfoHolder> {
        private static final long serialVersionUID = 1L;
        private static final String ERROR_FILE_NAME = "error.log.raw.json";
        private static final String SUCCESS_FILE_NAME = "success.json";

        UploadReportCallable(ATXConfig config, List<FilePath> reportFiles, EnvVars envVars, TaskListener listener) {
            super(config, reportFiles, envVars, listener);
        }

        public TestInfoHolder call() throws IOException {
            TestInfoHolder testInfo = null;
            TTConsoleLogger logger = new TTConsoleLogger(this.getListener());
            Map<String, String> configMap = this.getConfigMap(true);
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                TestEnvironment testEnv = (TestEnvironment)comClient.getTestEnvironment();
                List<FilePath> uploadFiles = this.getReportFiles();
                if (uploadFiles.isEmpty()) {
                    logger.logInfo("-> No report files found to upload!");
                } else {
                    for (FilePath uploadFile : uploadFiles) {
                        logger.logInfo(String.format("-> Generating and uploading ATX report: %s", uploadFile.getRemote()));
                        FilePath outDir = uploadFile.getParent().child("ATX");
                        testEnv.generateTestReportDocumentFromDB(uploadFile.getRemote(), outDir.getRemote(), "ATX", true, configMap);
                        comClient.waitForIdle(0);
                        FilePath successFile = outDir.child(SUCCESS_FILE_NAME);
                        if (testInfo == null) {
                            testInfo = this.checkSuccessLog(successFile, uploadFile, logger);
                        }
                        FilePath errorFile = outDir.child(ERROR_FILE_NAME);
                        this.checkErrorLog(errorFile, logger);
                    }
                }
            }
            catch (ETComException e) {
                logger.logComException(e.getMessage());
            }
            return testInfo;
        }

        private TestInfoHolder checkSuccessLog(FilePath successFile, FilePath uploadFile, TTConsoleLogger logger) throws IOException, MalformedURLException, UnsupportedEncodingException {
            TestInfoHolder testInfo;
            block3: {
                testInfo = null;
                try {
                    if (!successFile.exists()) break block3;
                    logger.logDebug("Uploading ATX report succeded:");
                    JSONObject jsonObject = (JSONObject)new JsonSlurper().parseText(successFile.readToString());
                    JSONArray jsonArray = jsonObject.optJSONArray("ENTRIES");
                    if (jsonArray == null) break block3;
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        String status = jsonArray.getJSONObject(i).getString("STATUS");
                        if (!"200".equals(status)) continue;
                        String file = jsonArray.getJSONObject(i).getString("FILE");
                        String text = jsonArray.getJSONObject(i).getString("TEXT");
                        logger.logDebug(String.format("%s: %s - %s", status, file, text));
                        URL location = this.resolveRedirect(text);
                        testInfo = this.parseTestInfo(location, uploadFile);
                        break;
                    }
                }
                catch (InterruptedException | URISyntaxException | KeyManagementException | NoSuchAlgorithmException | JSONException e) {
                    logger.logError("-> Could not parse ATX JSON response: " + e.getMessage());
                }
            }
            return testInfo;
        }

        private void checkErrorLog(FilePath errorFile, TTConsoleLogger logger) throws IOException {
            try {
                if (errorFile.exists()) {
                    logger.logError("Error while uploading ATX report:");
                    JSONObject jsonObject = (JSONObject)new JsonSlurper().parseText(errorFile.readToString());
                    JSONArray jsonArray = jsonObject.optJSONArray("ENTRIES");
                    if (jsonArray != null) {
                        for (int i = 0; i < jsonArray.size(); ++i) {
                            String file = jsonArray.getJSONObject(i).getString("FILE");
                            String status = jsonArray.getJSONObject(i).getString("STATUS");
                            String text = jsonArray.getJSONObject(i).getString("TEXT");
                            logger.logError(String.format("%s: %s - %s", status, file, text));
                        }
                    }
                }
            }
            catch (InterruptedException | JSONException e) {
                logger.logError("-> Could not parse ATX JSON response: " + e.getMessage());
            }
        }

        private TestInfoHolder parseTestInfo(URL url, FilePath uploadFile) throws URISyntaxException, UnsupportedEncodingException {
            Map<String, String> params = this.splitQuery(url);
            if (params.isEmpty()) {
                return null;
            }
            String testName = params.get("testexecplan");
            TestEnvInvisibleAction.TestType testType = TestEnvInvisibleAction.TestType.PROJECT;
            if ("SinglePackageExecution".equals(testName)) {
                testType = TestEnvInvisibleAction.TestType.PACKAGE;
                testName = uploadFile.getBaseName();
            }
            long from = Long.parseLong(params.get("dateFrom"));
            long to = Long.parseLong(params.get("dateTo"));
            return new TestInfoHolder(testName, testType, from, to);
        }

        private Map<String, String> splitQuery(URL url) throws UnsupportedEncodingException {
            String[] pairs;
            LinkedHashMap<String, String> queryMap = new LinkedHashMap<String, String>();
            String query = url.getQuery();
            for (String pair : pairs = query.split("&")) {
                int idx = pair.indexOf(61);
                queryMap.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
            }
            return queryMap;
        }

        private URL resolveRedirect(String redirect) throws MalformedURLException, NoSuchAlgorithmException, KeyManagementException, IOException {
            HttpURLConnection connection = null;
            URL url = new URL(redirect);
            if (redirect.startsWith("https://")) {
                ATXValidator.initSSLConnection();
                connection = (HttpsURLConnection)url.openConnection();
            } else {
                connection = (HttpURLConnection)url.openConnection();
            }
            connection.setInstanceFollowRedirects(false);
            connection.connect();
            String location = connection.getHeaderField("Location");
            return new URL(location);
        }
    }
}

