/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.atx;

import de.tracetronic.jenkins.plugins.ecutest.report.AbstractTestReport;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import jenkins.util.VirtualFile;
import org.apache.commons.lang.NotImplementedException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ATXReport
extends AbstractTestReport {
    private static final Logger LOGGER = Logger.getLogger(ATXReport.class.getName());
    private String reportUrl;
    private final boolean hasTrendReport;

    public ATXReport(String id, String title, String reportUrl) {
        super(id, title);
        this.reportUrl = reportUrl;
        this.hasTrendReport = false;
    }

    public ATXReport(String id, String title, String reportUrl, boolean hasTrendReport) {
        super(id, title);
        this.reportUrl = reportUrl;
        this.hasTrendReport = hasTrendReport;
    }

    public String getReportUrl() {
        return this.reportUrl;
    }

    public void setReportUrl(String reportUrl) {
        this.reportUrl = reportUrl;
    }

    public boolean hasTrendReport() {
        return this.hasTrendReport;
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException {
        Run<?, ?> build = this.getBuild(req);
        if (build == null) {
            LOGGER.warning(String.format("No build found for url %s", req.getRequestURI()));
            rsp.sendError(404);
            return;
        }
        URL url = new URL(this.getReportUrl());
        rsp.sendRedirect(url.toString());
    }

    @Override
    protected VirtualFile getArchiveTargetDir(File rootDir) {
        throw new NotImplementedException();
    }
}

