/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.atx;

import de.tracetronic.jenkins.plugins.ecutest.ETPlugin;
import de.tracetronic.jenkins.plugins.ecutest.ETPluginException;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractReportDescriptor;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractReportPublisher;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.ATXReportGenerator;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.ATXReportUploader;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.Messages;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXConfig;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXCustomSetting;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXInstallation;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXSetting;
import de.tracetronic.jenkins.plugins.ecutest.tool.client.ETClient;
import de.tracetronic.jenkins.plugins.ecutest.util.ATXUtil;
import de.tracetronic.jenkins.plugins.ecutest.util.ProcessUtil;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.ATXValidator;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class ATXPublisher
extends AbstractReportPublisher {
    protected static final String URL_NAME = "atx-reports";
    @Nonnull
    private final String atxName;

    @DataBoundConstructor
    public ATXPublisher(@Nonnull String atxName) {
        this.atxName = StringUtils.trimToEmpty((String)atxName);
    }

    @Nonnull
    public String getAtxName() {
        return this.atxName;
    }

    @Override
    public void performReport(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException, ETPluginException {
        TTConsoleLogger logger = this.getLogger();
        logger.logInfo("Publishing ATX reports...");
        ProcessUtil.checkOS(launcher);
        if (this.isSkipped(true, run, launcher)) {
            return;
        }
        ATXInstallation installation = this.getInstallation(run.getEnvironment(listener));
        if (installation == null) {
            throw new ETPluginException("Selected TEST-GUIDE installation is not configured!");
        }
        boolean isPublished = false;
        if (this.isETRunning(launcher)) {
            isPublished = this.publishReports(installation, run, workspace, launcher, listener);
        } else {
            String toolName = installation.getToolName();
            ETClient etClient = this.getToolClient(toolName, run, workspace, launcher, listener);
            if (etClient.start(false, workspace, launcher, listener)) {
                isPublished = this.publishReports(installation, run, workspace, launcher, listener);
            } else {
                logger.logError(String.format("Starting %s failed.", toolName));
            }
            if (!etClient.stop(true, workspace, launcher, listener)) {
                logger.logError(String.format("Stopping %s failed.", toolName));
            }
        }
        if (isPublished) {
            logger.logInfo("ATX reports published successfully.");
        } else {
            run.setResult(Result.FAILURE);
        }
    }

    private boolean publishReports(ATXInstallation installation, Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        TTConsoleLogger logger = this.getLogger();
        List<FilePath> reportDirs = this.getReportDirs(run, workspace, launcher);
        boolean isUploadEnabled = this.isUploadEnabled(installation);
        boolean isServerReachable = this.isServerReachable(installation, launcher, run.getEnvironment(listener));
        if (isUploadEnabled && isServerReachable) {
            logger.logInfo("- Generating and uploading ATX reports...");
            ATXReportUploader uploader = new ATXReportUploader(installation);
            return uploader.upload(reportDirs, this.isAllowMissing(), run, launcher, listener);
        }
        logger.logInfo("- Generating ATX reports...");
        if (isUploadEnabled && !isServerReachable) {
            logger.logWarn("-> ATX upload will be skipped because selected TEST-GUIDE server is not reachable!");
        }
        FilePath archiveTarget = this.getArchiveTarget(run);
        ATXReportGenerator generator = new ATXReportGenerator(installation);
        return generator.generate(archiveTarget, reportDirs, this.isAllowMissing(), this.isArchiving(), this.isKeepAll(), run, launcher, listener);
    }

    private boolean isUploadEnabled(ATXInstallation installation) {
        List<ATXSetting> uploadSettings;
        ATXConfig config = installation.getConfig();
        Object uploadToServer = config.getSettingValueByName("uploadToServer", uploadSettings = config.getConfigByName("uploadConfig"));
        return uploadToServer != null && (Boolean)uploadToServer != false;
    }

    private boolean isServerReachable(ATXInstallation installation, Launcher launcher, EnvVars envVars) throws IOException, InterruptedException {
        ATXConfig config = installation.getConfig();
        return (Boolean)launcher.getChannel().call((Callable)new TestConnectionCallable(config, envVars));
    }

    @CheckForNull
    public ATXInstallation getInstallation() {
        return this.getInstallation(new EnvVars());
    }

    @CheckForNull
    public ATXInstallation getInstallation(EnvVars envVars) {
        String expandedName = envVars.expand(this.atxName);
        return ATXInstallation.get(expandedName);
    }

    @Override
    public String getUrlName() {
        return URL_NAME;
    }

    @Symbol(value={"publishATX"})
    @Extension(ordinal=10007.0)
    public static class DescriptorImpl
    extends AbstractReportDescriptor {
        private volatile ATXInstallation[] installations = new ATXInstallation[0];
        private final transient ATXConfig defaultConfig;
        private final transient ATXValidator atxValidator;

        public DescriptorImpl() {
            this.load();
            this.atxValidator = new ATXValidator();
            this.defaultConfig = new ATXConfig();
        }

        public ATXInstallation[] getInstallations() {
            return (ATXInstallation[])this.installations.clone();
        }

        public void setInstallations(ATXInstallation ... installations) {
            ArrayList inst = new ArrayList();
            if (installations != null) {
                Collections.addAll(inst, installations);
                for (ATXInstallation installation : installations) {
                    if (!StringUtils.isBlank((String)installation.getName())) continue;
                    inst.remove(installation);
                }
            }
            this.installations = inst.toArray(new ATXInstallation[inst.size()]);
            this.save();
        }

        public ATXConfig getDefaultConfig() {
            return this.defaultConfig;
        }

        public boolean configure(StaplerRequest req, JSONObject json) {
            ArrayList<ATXInstallation> list = new ArrayList<ATXInstallation>();
            JSONArray instArray = new JSONArray();
            JSONArray inst = json.optJSONArray("installation");
            if (inst == null) {
                instArray.add((Object)json.getJSONObject("installation"));
            } else {
                instArray.addAll((Collection)inst);
            }
            for (Object instObject : instArray) {
                if (!(instObject instanceof JSONObject)) continue;
                JSONObject instJson = (JSONObject)instObject;
                String name = instJson.getString("name");
                String toolName = instJson.getString("toolName");
                Map<String, List<ATXSetting>> configMap = this.getDefaultConfig().getConfigMap();
                ArrayList<ATXCustomSetting> customSettings = req.bindJSONToList(ATXCustomSetting.class, instJson.get("customSettings"));
                ListIterator iterator = customSettings.listIterator();
                while (iterator.hasNext()) {
                    if (this.getDefaultConfig().getSettingByName(((ATXCustomSetting)iterator.next()).getName()) == null) continue;
                    iterator.remove();
                }
                customSettings = new ArrayList<ATXCustomSetting>(new LinkedHashSet(customSettings));
                ATXConfig config = new ATXConfig(this.updateCurrentValues(instJson, configMap), customSettings);
                ATXInstallation installation = new ATXInstallation(name, toolName, config);
                list.add(installation);
            }
            this.setInstallations(list.toArray(new ATXInstallation[list.size()]));
            return true;
        }

        public void syncWithDefaultConfig() {
            ArrayList<ATXInstallation> list = new ArrayList<ATXInstallation>();
            for (ATXInstallation installation : (ATXInstallation[])this.installations.clone()) {
                ATXConfig currentConfig = installation.getConfig();
                ATXConfig newConfig = this.defaultConfig.clone();
                if (currentConfig != null) {
                    for (Map.Entry<String, List<ATXSetting>> newConfigMap : newConfig.getConfigMap().entrySet()) {
                        for (ATXSetting newSetting : newConfigMap.getValue()) {
                            ATXSetting currentSetting = currentConfig.getSettingByName(newSetting.getName());
                            if (currentSetting == null) continue;
                            newSetting.setCurrentValue(currentSetting.getCurrentValue());
                        }
                    }
                    ArrayList customSettings = currentConfig.getCustomSettings();
                    newConfig.setCustomSettings(customSettings == null ? new ArrayList() : customSettings);
                }
                ATXInstallation inst = new ATXInstallation(installation.getName(), installation.getToolName(), newConfig);
                list.add(inst);
            }
            this.setInstallations(list.toArray(new ATXInstallation[list.size()]));
            this.load();
        }

        private Map<String, List<ATXSetting>> updateCurrentValues(JSONObject instJson, Map<String, List<ATXSetting>> configMap) {
            LinkedHashMap<String, List<ATXSetting>> newConfigMap = new LinkedHashMap<String, List<ATXSetting>>();
            for (Map.Entry<String, List<ATXSetting>> entry : configMap.entrySet()) {
                ArrayList<Object> newSettings = new ArrayList<Object>();
                List<ATXSetting> defaultSettings = entry.getValue();
                for (ATXSetting defaultSetting : defaultSettings) {
                    newSettings.add(defaultSetting.clone());
                }
                JSONObject configObject = instJson.optJSONObject(entry.getKey());
                if (configObject != null) {
                    for (ATXSetting aTXSetting : newSettings) {
                        Object configSetting = configObject.opt(aTXSetting.getName());
                        if (configSetting == null) continue;
                        aTXSetting.setCurrentValue(configSetting);
                    }
                }
                newConfigMap.put(entry.getKey(), newSettings);
            }
            return newConfigMap;
        }

        public static String getATXVersion() {
            return ETPlugin.ATX_VERSION.toMicroString();
        }

        public List<ATXCustomSetting> getCustomSettings(ATXInstallation installation) {
            return installation == null ? new ArrayList() : installation.getConfig().getCustomSettings();
        }

        public List<Descriptor<? extends ATXCustomSetting>> getApplicableCustomSettings() {
            ArrayList<Descriptor<? extends ATXCustomSetting>> list = new ArrayList<Descriptor<? extends ATXCustomSetting>>();
            DescriptorExtensionList<ATXCustomSetting, Descriptor<ATXCustomSetting>> settings = ATXCustomSetting.all();
            if (settings != null) {
                for (Descriptor setting : settings) {
                    list.add((Descriptor<? extends ATXCustomSetting>)setting);
                }
            }
            return list;
        }

        public String getDisplayName() {
            return Messages.ATXPublisher_DisplayName();
        }

        public FormValidation doCheckName(@QueryParameter String value) {
            return this.atxValidator.validateName(value);
        }

        public FormValidation doCheckSetting(@QueryParameter String name, @QueryParameter String value) {
            return this.atxValidator.validateSetting(name, value);
        }

        public FormValidation doTestConnection(@QueryParameter String serverURL, @QueryParameter String serverPort, @QueryParameter String serverContextPath, @QueryParameter boolean useHttpsConnection) {
            return this.atxValidator.testConnection(serverURL, serverPort, serverContextPath, useHttpsConnection);
        }
    }

    private static final class TestConnectionCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final ATXConfig config;
        private final EnvVars envVars;

        TestConnectionCallable(ATXConfig config, EnvVars envVars) {
            this.config = config;
            this.envVars = envVars;
        }

        public Boolean call() throws IOException {
            String baseUrl = ATXUtil.getBaseUrl(this.config, this.envVars);
            ATXValidator validator = new ATXValidator();
            FormValidation validation = validator.testConnection(baseUrl);
            return validation.kind.equals((Object)FormValidation.Kind.OK);
        }
    }
}

