/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.atx;

import de.tracetronic.jenkins.plugins.ecutest.report.AbstractTestReport;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.ATXProjectAction;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.ATXZipReport;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.AbstractATXAction;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.Messages;
import hudson.model.Action;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.tasks.SimpleBuildStep;

public class ATXBuildAction<T extends AbstractTestReport>
extends AbstractATXAction
implements SimpleBuildStep.LastBuildAction {
    private final List<T> atxReports = new ArrayList<T>();

    public ATXBuildAction(boolean projectLevel) {
        super(projectLevel);
    }

    public List<T> getATXReports() {
        return this.atxReports;
    }

    public boolean add(T report) {
        return this.getATXReports().add(report);
    }

    public boolean addAll(Collection<T> reports) {
        return this.getATXReports().addAll(reports);
    }

    public T getDynamic(String token) {
        for (AbstractTestReport report : this.getATXReports()) {
            if (token.equals(report.getId())) {
                return (T)report;
            }
            AbstractTestReport potentialReport = this.traverseSubReports(token, report);
            if (potentialReport == null) continue;
            return (T)potentialReport;
        }
        return null;
    }

    private T traverseSubReports(String token, T report) {
        for (AbstractTestReport subReport : ((AbstractTestReport)report).getSubReports()) {
            if (token.equals(subReport.getId())) {
                return (T)subReport;
            }
            AbstractTestReport potentialReport = this.traverseSubReports(token, subReport);
            if (potentialReport == null) continue;
            return (T)potentialReport;
        }
        return null;
    }

    public boolean hasArchivedReports() {
        return !this.getATXReports().isEmpty() && this.getATXReports().get(0) instanceof ATXZipReport;
    }

    public String getDisplayName() {
        return Messages.ATXBuildAction_DisplayName();
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.singleton(new ATXProjectAction(this.isProjectLevel()));
    }
}

