/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report;

import de.tracetronic.jenkins.plugins.ecutest.report.AbstractReportAction;
import hudson.model.Job;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import jenkins.util.VirtualFile;
import org.apache.commons.io.IOUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class AbstractRequestHandler {
    private static final Logger LOGGER = Logger.getLogger(AbstractRequestHandler.class.getName());

    @CheckForNull
    public Object getOwner(StaplerRequest req) {
        Run<?, ?> build = this.getAnchestorBuild(req);
        if (build != null) {
            return build;
        }
        Job<?, ?> project = this.getAnchestorProject(req);
        if (project != null) {
            return project;
        }
        return null;
    }

    @CheckForNull
    public abstract Run<?, ?> getBuild(StaplerRequest var1);

    protected abstract VirtualFile getArchiveTargetDir(File var1);

    @CheckForNull
    protected AbstractReportAction getBuildAction(StaplerRequest req) {
        return (AbstractReportAction)req.findAncestorObject(AbstractReportAction.class);
    }

    @CheckForNull
    protected Run<?, ?> getAnchestorBuild(StaplerRequest req) {
        return (Run)req.findAncestorObject(Run.class);
    }

    @CheckForNull
    protected Job<?, ?> getAnchestorProject(StaplerRequest req) {
        return (Job)req.findAncestorObject(Job.class);
    }

    public void doZipDownload(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Run<?, ?> build = this.getBuild(req);
        AbstractReportAction action = this.getBuildAction(req);
        if (build == null || action == null) {
            LOGGER.warning(String.format("No build or related action found for url %s", req.getRequestURI()));
            rsp.sendError(404);
            return;
        }
        boolean isProjectLevel = action.isProjectLevel();
        File rootDir = isProjectLevel ? build.getParent().getRootDir() : build.getRootDir();
        VirtualFile archiveDir = this.getArchiveTargetDir(rootDir);
        if (!archiveDir.exists()) {
            LOGGER.warning(String.format("Archive directory does not exists: %s for %s", archiveDir.getName(), build.getFullDisplayName()));
            rsp.sendError(404);
            return;
        }
        if (!archiveDir.isDirectory()) {
            LOGGER.warning(String.format("Archive is not a directory: %s for %s", archiveDir.getName(), build.getFullDisplayName()));
            rsp.sendError(403);
            return;
        }
        if (req.getDateHeader("If-Modified-Since") >= 0L && req.getDateHeader("If-Modified-Since") >= archiveDir.lastModified()) {
            rsp.setStatus(304);
            return;
        }
        String zipFileName = String.format("%s_%s#%d", archiveDir.getName(), build.getParent().getName(), build.getNumber());
        rsp.setHeader("Content-Disposition", "attachment;filename=\"" + zipFileName + "\"");
        rsp.setContentType("application/zip");
        this.zip((OutputStream)rsp.getOutputStream(), archiveDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zip(OutputStream outputStream, VirtualFile archiveDir) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(outputStream);
        zos.setEncoding(System.getProperty("file.encoding"));
        for (String archiveFile : archiveDir.list("**/**")) {
            ZipEntry entry = new ZipEntry(archiveFile.replace('\\', '/'));
            VirtualFile file = archiveDir.child(archiveFile);
            entry.setTime(file.lastModified());
            zos.putNextEntry(entry);
            InputStream in = file.open();
            try {
                IOUtils.copy((InputStream)in, (OutputStream)zos);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            zos.closeEntry();
        }
        zos.close();
    }
}

