/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report;

import de.tracetronic.jenkins.plugins.ecutest.report.AbstractReportAction;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractTestReport;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.util.VirtualFile;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class AbstractArchiveFileReport
extends AbstractTestReport {
    private static final Logger LOGGER = Logger.getLogger(AbstractArchiveFileReport.class.getName());
    private final String fileName;
    private final long fileSize;

    public AbstractArchiveFileReport(String id, String title, String fileName, long fileSize) {
        super(id, title);
        this.fileName = fileName;
        this.fileSize = fileSize;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public abstract String getArchiveDir();

    @Override
    protected VirtualFile getArchiveTargetDir(File rootDir) {
        return VirtualFile.forFile((File)new File(new File(rootDir, this.getArchiveDir()), this.getFileName()));
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Run<?, ?> build = this.getBuild(req);
        AbstractReportAction action = this.getBuildAction(req);
        if (build == null || action == null) {
            LOGGER.warning(String.format("No build or related action found for url %s", req.getRequestURI()));
            rsp.sendError(404);
            return;
        }
        boolean isProjectLevel = action.isProjectLevel();
        File rootDir = isProjectLevel ? build.getParent().getRootDir() : build.getRootDir();
        File archiveFile = new File(new File(rootDir, this.getArchiveDir()), this.getFileName());
        if (!archiveFile.exists()) {
            LOGGER.warning(String.format("Archive file does not exist: %s for %s", this.getFileName(), build.getFullDisplayName()));
            rsp.sendError(404);
            return;
        }
        if (!archiveFile.isFile()) {
            LOGGER.warning(String.format("Archive file is not a file: %s for %s", this.getFileName(), build.getFullDisplayName()));
            rsp.sendError(403);
            return;
        }
        if (req.getDateHeader("If-Modified-Since") >= 0L && req.getDateHeader("If-Modified-Since") >= archiveFile.lastModified()) {
            rsp.setStatus(304);
            return;
        }
        rsp.setHeader("Content-Disposition", "attachment;filename=\"" + archiveFile.getName() + "\"");
        rsp.serveFile(req, archiveFile.toURI().toURL());
    }
}

