/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.log;

import hudson.Extension;
import hudson.MarkupText;
import hudson.console.ConsoleAnnotationDescriptor;
import hudson.console.ConsoleAnnotator;
import hudson.console.ConsoleNote;
import java.util.Arrays;

public class TTConsoleNote
extends ConsoleNote<Object> {
    private static final long serialVersionUID = 1L;

    public ConsoleAnnotator<Object> annotate(Object context, MarkupText text, int charPos) {
        String plainText = text.getText();
        if (plainText.contains("ERROR:")) {
            text.addMarkup(0, text.length(), "<span style=\"font-weight: bold; color:#FF0000\">", "</span>");
        }
        if (plainText.contains("WARN:")) {
            text.addMarkup(0, text.length(), "<span style=\"color:#ED8B00\">", "</span>");
        }
        if (plainText.contains("INFO:")) {
            text.addMarkup(0, text.length(), "<span style=\"color:#208CA3\">", "</span>");
            this.addResultMarkup(text);
        }
        if (plainText.contains("DEBUG:")) {
            text.addMarkup(0, text.length(), "<span style=\"color:#63666A\">", "</span>");
        }
        return null;
    }

    private void addResultMarkup(MarkupText text) {
        String plainText = text.getText();
        for (String result : Arrays.asList("NONE", "INCONCLUSIVE", "SUCCESS", "FAILED", "ERROR")) {
            if (!plainText.contains("result: " + result)) continue;
            int startPos = plainText.indexOf(result);
            int endPos = startPos + result.length();
            String color = "NONE".equals(result) ? "#63666A" : ("INCONCLUSIVE".equals(result) ? "#ED8B00" : ("SUCCESS".equals(result) ? "#A1C057" : ("FAILED".equals(result) ? "#F25757" : ("ERROR".equals(result) ? "#B40000" : "#208CA3"))));
            text.addMarkup(startPos, endPos, "<span style=\"color:" + color + "\">", "</span>");
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends ConsoleAnnotationDescriptor {
        public String getDisplayName() {
            return "TraceTronic Console Note";
        }
    }
}

