/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.extension.jobdsl;

import com.google.common.base.Preconditions;
import de.tracetronic.jenkins.plugins.ecutest.extension.jobdsl.AbstractReportPublisherDslExtension;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.ATXPublisher;
import de.tracetronic.jenkins.plugins.ecutest.report.generator.ReportGeneratorConfig;
import de.tracetronic.jenkins.plugins.ecutest.report.generator.ReportGeneratorPublisher;
import de.tracetronic.jenkins.plugins.ecutest.report.generator.ReportGeneratorSetting;
import de.tracetronic.jenkins.plugins.ecutest.report.junit.JUnitPublisher;
import de.tracetronic.jenkins.plugins.ecutest.report.log.ETLogPublisher;
import de.tracetronic.jenkins.plugins.ecutest.report.tms.TMSPublisher;
import de.tracetronic.jenkins.plugins.ecutest.report.trf.TRFPublisher;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.ReportGeneratorValidator;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.TMSValidator;
import hudson.Extension;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.List;
import javaposse.jobdsl.dsl.Context;
import javaposse.jobdsl.dsl.helpers.publisher.PublisherContext;
import javaposse.jobdsl.plugin.ContextExtensionPoint;
import javaposse.jobdsl.plugin.DslExtensionMethod;
import org.apache.commons.lang.StringUtils;

@Extension(optional=true)
public class ReportPublisherDslExtension
extends AbstractReportPublisherDslExtension {
    private static final String OPT_ATX_NAME = "atxName";
    private static final String OPT_CREDENTIALS_ID = "credentialsId";

    @DslExtensionMethod(context=PublisherContext.class)
    public Object publishATX(CharSequence atxName, Runnable closure) {
        Preconditions.checkNotNull((Object)atxName, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_ATX_NAME});
        PublishATXContext context = new PublishATXContext();
        ReportPublisherDslExtension.executeInContext((Runnable)closure, (Context)context);
        ATXPublisher publisher = new ATXPublisher(atxName.toString());
        publisher.setAllowMissing(context.allowMissing);
        publisher.setRunOnFailed(context.runOnFailed);
        publisher.setArchiving(context.archiving);
        publisher.setKeepAll(context.keepAll);
        this.checkATXInstallation(atxName.toString(), publisher);
        return publisher;
    }

    private void checkATXInstallation(String atxName, ATXPublisher publisher) {
        if (StringUtils.containsNone((String)atxName, (String)"$")) {
            Preconditions.checkNotNull((Object)publisher.getInstallation(), (String)"'%s' is not in the list of configured ECU-TEST installations!", (Object[])new Object[]{atxName});
        }
    }

    @DslExtensionMethod(context=PublisherContext.class)
    public Object publishATX(CharSequence atxName) {
        return this.publishATX(atxName, null);
    }

    @DslExtensionMethod(context=PublisherContext.class)
    public Object publishUNIT(CharSequence toolName, Runnable closure) {
        Preconditions.checkNotNull((Object)toolName, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"toolName"});
        PublishUNITContext context = new PublishUNITContext();
        ReportPublisherDslExtension.executeInContext((Runnable)closure, (Context)context);
        JUnitPublisher publisher = new JUnitPublisher(toolName.toString());
        publisher.setUnstableThreshold(context.unstableThreshold);
        publisher.setFailedThreshold(context.failedThreshold);
        publisher.setAllowMissing(context.allowMissing);
        publisher.setRunOnFailed(context.runOnFailed);
        publisher.setArchiving(context.archiving);
        publisher.setKeepAll(context.keepAll);
        this.checkToolInstallation(toolName.toString(), publisher);
        return publisher;
    }

    @DslExtensionMethod(context=PublisherContext.class)
    public Object publishUNIT(CharSequence toolName) {
        return this.publishUNIT(toolName, null);
    }

    @DslExtensionMethod(context=PublisherContext.class)
    public Object publishTRF(Runnable closure) {
        PublishTRFContext context = new PublishTRFContext();
        ReportPublisherDslExtension.executeInContext((Runnable)closure, (Context)context);
        TRFPublisher publisher = new TRFPublisher();
        publisher.setAllowMissing(context.allowMissing);
        publisher.setRunOnFailed(context.runOnFailed);
        publisher.setArchiving(context.archiving);
        publisher.setKeepAll(context.keepAll);
        return publisher;
    }

    @DslExtensionMethod(context=PublisherContext.class)
    public Object publishTRF() {
        return this.publishTRF(null);
    }

    @DslExtensionMethod(context=PublisherContext.class)
    public Object publishETLogs(Runnable closure) {
        PublishETLogContext context = new PublishETLogContext();
        ReportPublisherDslExtension.executeInContext((Runnable)closure, (Context)context);
        ETLogPublisher publisher = new ETLogPublisher();
        publisher.setUnstableOnWarning(context.unstableOnWarning);
        publisher.setFailedOnError(context.failedOnError);
        publisher.setTestSpecific(context.testSpecific);
        publisher.setAllowMissing(context.allowMissing);
        publisher.setRunOnFailed(context.runOnFailed);
        publisher.setArchiving(context.archiving);
        publisher.setKeepAll(context.keepAll);
        return publisher;
    }

    @DslExtensionMethod(context=PublisherContext.class)
    public Object publishETLogs() {
        return this.publishETLogs(null);
    }

    @DslExtensionMethod(context=PublisherContext.class)
    public Object publishGenerators(CharSequence toolName, Runnable closure) {
        Preconditions.checkNotNull((Object)toolName, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"toolName"});
        PublishGeneratorsContext context = new PublishGeneratorsContext();
        ReportPublisherDslExtension.executeInContext((Runnable)closure, (Context)context);
        ReportGeneratorPublisher publisher = new ReportGeneratorPublisher(toolName.toString());
        publisher.setGenerators(context.generators);
        publisher.setCustomGenerators(context.customGenerators);
        publisher.setAllowMissing(context.allowMissing);
        publisher.setRunOnFailed(context.runOnFailed);
        publisher.setArchiving(context.archiving);
        publisher.setKeepAll(context.keepAll);
        this.checkToolInstallation(toolName.toString(), publisher);
        return publisher;
    }

    @DslExtensionMethod(context=PublisherContext.class)
    public Object publishGenerators(CharSequence toolName) {
        return this.publishGenerators(toolName, null);
    }

    @DslExtensionMethod(context=PublisherContext.class)
    public Object publishTMS(CharSequence toolName, CharSequence credentialsId, Runnable closure) {
        Preconditions.checkNotNull((Object)toolName, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"toolName"});
        Preconditions.checkNotNull((Object)credentialsId, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_CREDENTIALS_ID});
        PublishTMSContext context = new PublishTMSContext();
        ReportPublisherDslExtension.executeInContext((Runnable)closure, (Context)context);
        TMSPublisher publisher = new TMSPublisher(toolName.toString(), credentialsId.toString());
        publisher.setTimeout(context.timeout);
        publisher.setAllowMissing(context.allowMissing);
        publisher.setRunOnFailed(context.runOnFailed);
        publisher.setArchiving(context.archiving);
        publisher.setKeepAll(context.keepAll);
        this.checkToolInstallation(toolName.toString(), publisher);
        return publisher;
    }

    @DslExtensionMethod(context=PublisherContext.class)
    public Object publishTMS(CharSequence toolName, CharSequence credentialsId) {
        return this.publishTMS(toolName, credentialsId, null);
    }

    public class PublishTMSContext
    extends AbstractReportPublisherDslExtension.AbstractReportContext {
        protected final TMSValidator tmsValidator = new TMSValidator();
        private String timeout;

        public void timeout(String value) {
            FormValidation validation = this.tmsValidator.validateTimeout(value, TMSPublisher.getDefaultTimeout());
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            this.timeout = value;
        }
    }

    public class PublishGeneratorsContext
    extends AbstractReportPublisherDslExtension.AbstractReportContext {
        private List<ReportGeneratorConfig> generators;
        private List<ReportGeneratorConfig> customGenerators;

        public void generators(Runnable closure) {
            ReportGeneratorContext context = new ReportGeneratorContext();
            ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
            this.generators = context.generators;
        }

        public void customGenerators(Runnable closure) {
            ReportGeneratorContext context = new ReportGeneratorContext();
            ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
            this.customGenerators = context.generators;
        }

        public class ReportGeneratorContext
        implements Context {
            private static final String OPT_GENERATOR_NAME = "generator name";
            private final List<ReportGeneratorConfig> generators = new ArrayList<ReportGeneratorConfig>();
            protected final ReportGeneratorValidator reportValidator = new ReportGeneratorValidator();

            public void generator(CharSequence name) {
                Preconditions.checkNotNull((Object)name, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_GENERATOR_NAME});
                FormValidation validation = this.reportValidator.validateGeneratorName(name.toString());
                Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
                this.generators.add(new ReportGeneratorConfig(name.toString(), null));
            }

            public void generator(CharSequence name, Runnable closure) {
                ReportGeneratorConfigContext context = new ReportGeneratorConfigContext();
                ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
                this.generators.add(new ReportGeneratorConfig(name.toString(), context.settings));
            }

            public void customGenerator(CharSequence name) {
                this.generator(name);
            }

            public void customGenerator(CharSequence name, Runnable closure) {
                this.generator(name, closure);
            }

            public class ReportGeneratorSettingsContext
            implements Context {
                private static final String OPT_SETTING_NAME = "setting name";
                private static final String OPT_SETTING_VALUE = "setting value";
                private final List<ReportGeneratorSetting> settings = new ArrayList<ReportGeneratorSetting>();

                public void setting(CharSequence name, CharSequence value) {
                    Preconditions.checkNotNull((Object)name, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_SETTING_NAME});
                    Preconditions.checkNotNull((Object)value, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_SETTING_VALUE});
                    FormValidation validation = ReportGeneratorContext.this.reportValidator.validateSettingName(name.toString());
                    Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
                    validation = ReportGeneratorContext.this.reportValidator.validateSettingValue(value.toString());
                    Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
                    this.settings.add(new ReportGeneratorSetting(name.toString(), value.toString()));
                }

                public void setting(Runnable closure) {
                    ReportGeneratorSettingContext context = new ReportGeneratorSettingContext();
                    ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
                    this.settings.add(new ReportGeneratorSetting(context.name, context.value));
                }

                public class ReportGeneratorSettingContext
                implements Context {
                    private String name;
                    private String value;

                    public void name(CharSequence value) {
                        Preconditions.checkNotNull((Object)value, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{ReportGeneratorSettingsContext.OPT_SETTING_NAME});
                        FormValidation validation = ReportGeneratorContext.this.reportValidator.validateSettingName(value.toString());
                        Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
                        this.name = value.toString();
                    }

                    public void value(CharSequence value) {
                        Preconditions.checkNotNull((Object)value, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{ReportGeneratorSettingsContext.OPT_SETTING_VALUE});
                        FormValidation validation = ReportGeneratorContext.this.reportValidator.validateSettingValue(value.toString());
                        Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
                        this.value = value.toString();
                    }
                }
            }

            public class ReportGeneratorConfigContext
            implements Context {
                private List<ReportGeneratorSetting> settings;

                public void settings(Runnable closure) {
                    ReportGeneratorSettingsContext context = new ReportGeneratorSettingsContext();
                    ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
                    this.settings = context.settings;
                }
            }
        }
    }

    public class PublishETLogContext
    extends AbstractReportPublisherDslExtension.AbstractReportContext {
        private boolean unstableOnWarning;
        private boolean failedOnError;
        private boolean testSpecific;

        public void unstableOnWarning(boolean value) {
            this.unstableOnWarning = value;
        }

        public void failedOnError(boolean value) {
            this.failedOnError = value;
        }

        public void testSpecific(boolean value) {
            this.testSpecific = value;
        }
    }

    public class PublishTRFContext
    extends AbstractReportPublisherDslExtension.AbstractReportContext {
    }

    public class PublishUNITContext
    extends AbstractReportPublisherDslExtension.AbstractReportContext {
        private double unstableThreshold;
        private double failedThreshold;

        public void unstableThreshold(double value) {
            FormValidation validation = ReportPublisherDslExtension.this.validator.validateUnstableThreshold(String.valueOf(value));
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            this.unstableThreshold = value;
        }

        public void failedThreshold(double value) {
            FormValidation validation = ReportPublisherDslExtension.this.validator.validateFailedThreshold(String.valueOf(value));
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            this.failedThreshold = value;
        }
    }

    public class PublishATXContext
    extends AbstractReportPublisherDslExtension.AbstractReportContext {
    }
}

