/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.env;

import de.tracetronic.jenkins.plugins.ecutest.env.TestEnvInvisibleAction;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.EnvironmentContributor;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;

@Extension
public class TestEnvContributor
extends EnvironmentContributor {
    public static final String PREFIX = "TT_";
    public static final String TEST_NAME = "TEST_NAME_";
    public static final String TEST_TYPE = "TEST_TYPE_";
    public static final String TEST_DESCRIPTION = "TEST_DESCRIPTION_";
    public static final String TEST_FILE = "TEST_FILE_";
    public static final String TEST_TBC = "TEST_TBC_";
    public static final String TEST_TCF = "TEST_TCF_";
    public static final String TEST_REPORT = "TEST_REPORT_";
    public static final String TEST_RESULT = "TEST_RESULT_";
    public static final String TEST_TIMEOUT = "TEST_TIMEOUT_";

    public void buildEnvironmentFor(Run r, EnvVars envs, TaskListener listener) throws IOException, InterruptedException {
        List envActions = r.getActions(TestEnvInvisibleAction.class);
        if (envActions.size() == 0) {
            return;
        }
        for (TestEnvInvisibleAction action : envActions) {
            String id = String.valueOf(action.getTestId());
            TestEnvInvisibleAction.TestType testType = action.getTestType();
            if (testType.equals((Object)TestEnvInvisibleAction.TestType.PACKAGE)) {
                envs.put("TT_TEST_DESCRIPTION_" + id, action.getTestDescription());
            }
            envs.put("TT_TEST_NAME_" + id, action.getTestName());
            envs.put("TT_TEST_TYPE_" + id, testType.name());
            envs.put("TT_TEST_FILE_" + id, action.getTestFile());
            envs.put("TT_TEST_TBC_" + id, action.getTestTbc());
            envs.put("TT_TEST_TCF_" + id, action.getTestTcf());
            envs.put("TT_TEST_REPORT_" + id, action.getTestReportDir());
            envs.put("TT_TEST_RESULT_" + id, action.getTestResult());
            envs.put("TT_TEST_TIMEOUT_" + id, String.valueOf(action.getTimeout()));
        }
    }
}

